// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteSampleV2Reader is a Reader for the DeleteSampleV2 structure.
type DeleteSampleV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteSampleV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteSampleV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteSampleV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteSampleV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteSampleV2NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteSampleV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteSampleV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /samples/entities/samples/v2] DeleteSampleV2", response, response.Code())
	}
}

// NewDeleteSampleV2OK creates a DeleteSampleV2OK with default headers values
func NewDeleteSampleV2OK() *DeleteSampleV2OK {
	return &DeleteSampleV2OK{}
}

/*
DeleteSampleV2OK describes a response with status code 200, with default header values.

OK
*/
type DeleteSampleV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete sample v2 o k response has a 2xx status code
func (o *DeleteSampleV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete sample v2 o k response has a 3xx status code
func (o *DeleteSampleV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 o k response has a 4xx status code
func (o *DeleteSampleV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete sample v2 o k response has a 5xx status code
func (o *DeleteSampleV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sample v2 o k response a status code equal to that given
func (o *DeleteSampleV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete sample v2 o k response
func (o *DeleteSampleV2OK) Code() int {
	return 200
}

func (o *DeleteSampleV2OK) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2OK  %+v", 200, o.Payload)
}

func (o *DeleteSampleV2OK) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2OK  %+v", 200, o.Payload)
}

func (o *DeleteSampleV2OK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteSampleV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSampleV2BadRequest creates a DeleteSampleV2BadRequest with default headers values
func NewDeleteSampleV2BadRequest() *DeleteSampleV2BadRequest {
	return &DeleteSampleV2BadRequest{}
}

/*
DeleteSampleV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteSampleV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete sample v2 bad request response has a 2xx status code
func (o *DeleteSampleV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete sample v2 bad request response has a 3xx status code
func (o *DeleteSampleV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 bad request response has a 4xx status code
func (o *DeleteSampleV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete sample v2 bad request response has a 5xx status code
func (o *DeleteSampleV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sample v2 bad request response a status code equal to that given
func (o *DeleteSampleV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete sample v2 bad request response
func (o *DeleteSampleV2BadRequest) Code() int {
	return 400
}

func (o *DeleteSampleV2BadRequest) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteSampleV2BadRequest) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteSampleV2BadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteSampleV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSampleV2Forbidden creates a DeleteSampleV2Forbidden with default headers values
func NewDeleteSampleV2Forbidden() *DeleteSampleV2Forbidden {
	return &DeleteSampleV2Forbidden{}
}

/*
DeleteSampleV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteSampleV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete sample v2 forbidden response has a 2xx status code
func (o *DeleteSampleV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete sample v2 forbidden response has a 3xx status code
func (o *DeleteSampleV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 forbidden response has a 4xx status code
func (o *DeleteSampleV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete sample v2 forbidden response has a 5xx status code
func (o *DeleteSampleV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sample v2 forbidden response a status code equal to that given
func (o *DeleteSampleV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete sample v2 forbidden response
func (o *DeleteSampleV2Forbidden) Code() int {
	return 403
}

func (o *DeleteSampleV2Forbidden) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteSampleV2Forbidden) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteSampleV2Forbidden) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteSampleV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSampleV2NotFound creates a DeleteSampleV2NotFound with default headers values
func NewDeleteSampleV2NotFound() *DeleteSampleV2NotFound {
	return &DeleteSampleV2NotFound{}
}

/*
DeleteSampleV2NotFound describes a response with status code 404, with default header values.

Not Found
*/
type DeleteSampleV2NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete sample v2 not found response has a 2xx status code
func (o *DeleteSampleV2NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete sample v2 not found response has a 3xx status code
func (o *DeleteSampleV2NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 not found response has a 4xx status code
func (o *DeleteSampleV2NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete sample v2 not found response has a 5xx status code
func (o *DeleteSampleV2NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sample v2 not found response a status code equal to that given
func (o *DeleteSampleV2NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete sample v2 not found response
func (o *DeleteSampleV2NotFound) Code() int {
	return 404
}

func (o *DeleteSampleV2NotFound) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2NotFound  %+v", 404, o.Payload)
}

func (o *DeleteSampleV2NotFound) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2NotFound  %+v", 404, o.Payload)
}

func (o *DeleteSampleV2NotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteSampleV2NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSampleV2TooManyRequests creates a DeleteSampleV2TooManyRequests with default headers values
func NewDeleteSampleV2TooManyRequests() *DeleteSampleV2TooManyRequests {
	return &DeleteSampleV2TooManyRequests{}
}

/*
DeleteSampleV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteSampleV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete sample v2 too many requests response has a 2xx status code
func (o *DeleteSampleV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete sample v2 too many requests response has a 3xx status code
func (o *DeleteSampleV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 too many requests response has a 4xx status code
func (o *DeleteSampleV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete sample v2 too many requests response has a 5xx status code
func (o *DeleteSampleV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sample v2 too many requests response a status code equal to that given
func (o *DeleteSampleV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete sample v2 too many requests response
func (o *DeleteSampleV2TooManyRequests) Code() int {
	return 429
}

func (o *DeleteSampleV2TooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteSampleV2TooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteSampleV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteSampleV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSampleV2InternalServerError creates a DeleteSampleV2InternalServerError with default headers values
func NewDeleteSampleV2InternalServerError() *DeleteSampleV2InternalServerError {
	return &DeleteSampleV2InternalServerError{}
}

/*
DeleteSampleV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteSampleV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete sample v2 internal server error response has a 2xx status code
func (o *DeleteSampleV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete sample v2 internal server error response has a 3xx status code
func (o *DeleteSampleV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sample v2 internal server error response has a 4xx status code
func (o *DeleteSampleV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete sample v2 internal server error response has a 5xx status code
func (o *DeleteSampleV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete sample v2 internal server error response a status code equal to that given
func (o *DeleteSampleV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete sample v2 internal server error response
func (o *DeleteSampleV2InternalServerError) Code() int {
	return 500
}

func (o *DeleteSampleV2InternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteSampleV2InternalServerError) String() string {
	return fmt.Sprintf("[DELETE /samples/entities/samples/v2][%d] deleteSampleV2InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteSampleV2InternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteSampleV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
