// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new falconx sandbox API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for falconx sandbox API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DeleteReport(params *DeleteReportParams, opts ...ClientOption) (*DeleteReportAccepted, error)

	DeleteSampleV2(params *DeleteSampleV2Params, opts ...ClientOption) (*DeleteSampleV2OK, error)

	GetArtifacts(params *GetArtifactsParams, opts ...ClientOption) (*GetArtifactsOK, error)

	GetMemoryDump(params *GetMemoryDumpParams, opts ...ClientOption) (*GetMemoryDumpOK, error)

	GetMemoryDumpExtractedStrings(params *GetMemoryDumpExtractedStringsParams, opts ...ClientOption) (*GetMemoryDumpExtractedStringsOK, error)

	GetMemoryDumpHexDump(params *GetMemoryDumpHexDumpParams, opts ...ClientOption) (*GetMemoryDumpHexDumpOK, error)

	GetReports(params *GetReportsParams, opts ...ClientOption) (*GetReportsOK, error)

	GetSampleV2(params *GetSampleV2Params, opts ...ClientOption) (*GetSampleV2OK, error)

	GetSubmissions(params *GetSubmissionsParams, opts ...ClientOption) (*GetSubmissionsOK, error)

	GetSummaryReports(params *GetSummaryReportsParams, opts ...ClientOption) (*GetSummaryReportsOK, error)

	QueryReports(params *QueryReportsParams, opts ...ClientOption) (*QueryReportsOK, error)

	QuerySampleV1(params *QuerySampleV1Params, opts ...ClientOption) (*QuerySampleV1OK, error)

	QuerySubmissions(params *QuerySubmissionsParams, opts ...ClientOption) (*QuerySubmissionsOK, error)

	Submit(params *SubmitParams, opts ...ClientOption) (*SubmitOK, error)

	UploadSampleV2(params *UploadSampleV2Params, opts ...ClientOption) (*UploadSampleV2OK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
DeleteReport deletes report based on the report ID operation can be checked for success by polling for the report ID on the report summaries endpoint
*/
func (a *Client) DeleteReport(params *DeleteReportParams, opts ...ClientOption) (*DeleteReportAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteReport",
		Method:             "DELETE",
		PathPattern:        "/falconx/entities/reports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteReportAccepted)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteReport: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteSampleV2 removes a sample including file meta and submissions from the collection
*/
func (a *Client) DeleteSampleV2(params *DeleteSampleV2Params, opts ...ClientOption) (*DeleteSampleV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteSampleV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteSampleV2",
		Method:             "DELETE",
		PathPattern:        "/samples/entities/samples/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"*/*"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteSampleV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteSampleV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteSampleV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetArtifacts downloads i o c packs p c a p files memory dumps and other analysis artifacts
*/
func (a *Client) GetArtifacts(params *GetArtifactsParams, opts ...ClientOption) (*GetArtifactsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetArtifactsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetArtifacts",
		Method:             "GET",
		PathPattern:        "/falconx/entities/artifacts/v1",
		ProducesMediaTypes: []string{"*/*", "application/gzip", "application/json", "application/octet-stream", "image/jpeg", "image/png", "text/csv", "text/plain"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetArtifactsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetArtifactsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetArtifacts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetMemoryDump gets memory dump content as binary
*/
func (a *Client) GetMemoryDump(params *GetMemoryDumpParams, opts ...ClientOption) (*GetMemoryDumpOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetMemoryDumpParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMemoryDump",
		Method:             "GET",
		PathPattern:        "/falconx/entities/memory-dump/v1",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetMemoryDumpReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMemoryDumpOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetMemoryDump: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetMemoryDumpExtractedStrings gets extracted strings from a memory dump
*/
func (a *Client) GetMemoryDumpExtractedStrings(params *GetMemoryDumpExtractedStringsParams, opts ...ClientOption) (*GetMemoryDumpExtractedStringsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetMemoryDumpExtractedStringsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMemoryDumpExtractedStrings",
		Method:             "GET",
		PathPattern:        "/falconx/entities/memory-dump/extracted-strings/v1",
		ProducesMediaTypes: []string{"application/json", "application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetMemoryDumpExtractedStringsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMemoryDumpExtractedStringsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetMemoryDumpExtractedStrings: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetMemoryDumpHexDump gets hex view of a memory dump
*/
func (a *Client) GetMemoryDumpHexDump(params *GetMemoryDumpHexDumpParams, opts ...ClientOption) (*GetMemoryDumpHexDumpOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetMemoryDumpHexDumpParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMemoryDumpHexDump",
		Method:             "GET",
		PathPattern:        "/falconx/entities/memory-dump/hex-dump/v1",
		ProducesMediaTypes: []string{"application/json", "application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetMemoryDumpHexDumpReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMemoryDumpHexDumpOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetMemoryDumpHexDump: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetReports gets a full sandbox report
*/
func (a *Client) GetReports(params *GetReportsParams, opts ...ClientOption) (*GetReportsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetReportsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetReports",
		Method:             "GET",
		PathPattern:        "/falconx/entities/reports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetReportsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetReportsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetReports: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSampleV2 retrieves the file associated with the given ID s h a256
*/
func (a *Client) GetSampleV2(params *GetSampleV2Params, opts ...ClientOption) (*GetSampleV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSampleV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSampleV2",
		Method:             "GET",
		PathPattern:        "/samples/entities/samples/v2",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"*/*"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSampleV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSampleV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSampleV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSubmissions checks the status of a sandbox analysis time required for analysis varies but is usually less than 15 minutes
*/
func (a *Client) GetSubmissions(params *GetSubmissionsParams, opts ...ClientOption) (*GetSubmissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSubmissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSubmissions",
		Method:             "GET",
		PathPattern:        "/falconx/entities/submissions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSubmissionsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSubmissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSubmissions: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSummaryReports gets a short summary version of a sandbox report
*/
func (a *Client) GetSummaryReports(params *GetSummaryReportsParams, opts ...ClientOption) (*GetSummaryReportsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSummaryReportsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSummaryReports",
		Method:             "GET",
		PathPattern:        "/falconx/entities/report-summaries/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSummaryReportsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSummaryReportsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSummaryReports: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryReports finds sandbox reports by providing an f q l filter and paging details returns a set of report i ds that match your criteria
*/
func (a *Client) QueryReports(params *QueryReportsParams, opts ...ClientOption) (*QueryReportsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryReportsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryReports",
		Method:             "GET",
		PathPattern:        "/falconx/queries/reports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryReportsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryReportsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryReports: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QuerySampleV1 retrieves a list with sha256 of samples that exist and customer has rights to access them maximum number of accepted items is 200
*/
func (a *Client) QuerySampleV1(params *QuerySampleV1Params, opts ...ClientOption) (*QuerySampleV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuerySampleV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "QuerySampleV1",
		Method:             "POST",
		PathPattern:        "/samples/queries/samples/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuerySampleV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuerySampleV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QuerySampleV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QuerySubmissions finds submission i ds for uploaded files by providing an f q l filter and paging details returns a set of submission i ds that match your criteria
*/
func (a *Client) QuerySubmissions(params *QuerySubmissionsParams, opts ...ClientOption) (*QuerySubmissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQuerySubmissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "QuerySubmissions",
		Method:             "GET",
		PathPattern:        "/falconx/queries/submissions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QuerySubmissionsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QuerySubmissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QuerySubmissions: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
Submit submits an uploaded file or a URL for sandbox analysis time required for analysis varies but is usually less than 15 minutes
*/
func (a *Client) Submit(params *SubmitParams, opts ...ClientOption) (*SubmitOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSubmitParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Submit",
		Method:             "POST",
		PathPattern:        "/falconx/entities/submissions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SubmitReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SubmitOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for Submit: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UploadSampleV2 uploads a file for sandbox analysis after uploading use falconx entities submissions v1 to start analyzing the file
*/
func (a *Client) UploadSampleV2(params *UploadSampleV2Params, opts ...ClientOption) (*UploadSampleV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUploadSampleV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "UploadSampleV2",
		Method:             "POST",
		PathPattern:        "/samples/entities/samples/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/octet-stream", "multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UploadSampleV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UploadSampleV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UploadSampleV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
