// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMemoryDumpExtractedStringsReader is a Reader for the GetMemoryDumpExtractedStrings structure.
type GetMemoryDumpExtractedStringsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMemoryDumpExtractedStringsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMemoryDumpExtractedStringsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetMemoryDumpExtractedStringsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetMemoryDumpExtractedStringsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetMemoryDumpExtractedStringsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMemoryDumpExtractedStringsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetMemoryDumpExtractedStringsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /falconx/entities/memory-dump/extracted-strings/v1] GetMemoryDumpExtractedStrings", response, response.Code())
	}
}

// NewGetMemoryDumpExtractedStringsOK creates a GetMemoryDumpExtractedStringsOK with default headers values
func NewGetMemoryDumpExtractedStringsOK() *GetMemoryDumpExtractedStringsOK {
	return &GetMemoryDumpExtractedStringsOK{}
}

/*
GetMemoryDumpExtractedStringsOK describes a response with status code 200, with default header values.

OK
*/
type GetMemoryDumpExtractedStringsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this get memory dump extracted strings o k response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get memory dump extracted strings o k response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings o k response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get memory dump extracted strings o k response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump extracted strings o k response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get memory dump extracted strings o k response
func (o *GetMemoryDumpExtractedStringsOK) Code() int {
	return 200
}

func (o *GetMemoryDumpExtractedStringsOK) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsOK  %+v", 200, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsOK) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsOK  %+v", 200, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpExtractedStringsBadRequest creates a GetMemoryDumpExtractedStringsBadRequest with default headers values
func NewGetMemoryDumpExtractedStringsBadRequest() *GetMemoryDumpExtractedStringsBadRequest {
	return &GetMemoryDumpExtractedStringsBadRequest{}
}

/*
GetMemoryDumpExtractedStringsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetMemoryDumpExtractedStringsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump extracted strings bad request response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump extracted strings bad request response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings bad request response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump extracted strings bad request response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump extracted strings bad request response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get memory dump extracted strings bad request response
func (o *GetMemoryDumpExtractedStringsBadRequest) Code() int {
	return 400
}

func (o *GetMemoryDumpExtractedStringsBadRequest) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsBadRequest  %+v", 400, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsBadRequest) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsBadRequest  %+v", 400, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpExtractedStringsForbidden creates a GetMemoryDumpExtractedStringsForbidden with default headers values
func NewGetMemoryDumpExtractedStringsForbidden() *GetMemoryDumpExtractedStringsForbidden {
	return &GetMemoryDumpExtractedStringsForbidden{}
}

/*
GetMemoryDumpExtractedStringsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMemoryDumpExtractedStringsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get memory dump extracted strings forbidden response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump extracted strings forbidden response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings forbidden response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump extracted strings forbidden response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump extracted strings forbidden response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get memory dump extracted strings forbidden response
func (o *GetMemoryDumpExtractedStringsForbidden) Code() int {
	return 403
}

func (o *GetMemoryDumpExtractedStringsForbidden) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsForbidden  %+v", 403, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsForbidden) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsForbidden  %+v", 403, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpExtractedStringsNotFound creates a GetMemoryDumpExtractedStringsNotFound with default headers values
func NewGetMemoryDumpExtractedStringsNotFound() *GetMemoryDumpExtractedStringsNotFound {
	return &GetMemoryDumpExtractedStringsNotFound{}
}

/*
GetMemoryDumpExtractedStringsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetMemoryDumpExtractedStringsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump extracted strings not found response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump extracted strings not found response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings not found response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump extracted strings not found response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump extracted strings not found response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get memory dump extracted strings not found response
func (o *GetMemoryDumpExtractedStringsNotFound) Code() int {
	return 404
}

func (o *GetMemoryDumpExtractedStringsNotFound) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsNotFound  %+v", 404, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsNotFound) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsNotFound  %+v", 404, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpExtractedStringsTooManyRequests creates a GetMemoryDumpExtractedStringsTooManyRequests with default headers values
func NewGetMemoryDumpExtractedStringsTooManyRequests() *GetMemoryDumpExtractedStringsTooManyRequests {
	return &GetMemoryDumpExtractedStringsTooManyRequests{}
}

/*
GetMemoryDumpExtractedStringsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMemoryDumpExtractedStringsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get memory dump extracted strings too many requests response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump extracted strings too many requests response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings too many requests response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump extracted strings too many requests response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump extracted strings too many requests response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get memory dump extracted strings too many requests response
func (o *GetMemoryDumpExtractedStringsTooManyRequests) Code() int {
	return 429
}

func (o *GetMemoryDumpExtractedStringsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpExtractedStringsInternalServerError creates a GetMemoryDumpExtractedStringsInternalServerError with default headers values
func NewGetMemoryDumpExtractedStringsInternalServerError() *GetMemoryDumpExtractedStringsInternalServerError {
	return &GetMemoryDumpExtractedStringsInternalServerError{}
}

/*
GetMemoryDumpExtractedStringsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetMemoryDumpExtractedStringsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump extracted strings internal server error response has a 2xx status code
func (o *GetMemoryDumpExtractedStringsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump extracted strings internal server error response has a 3xx status code
func (o *GetMemoryDumpExtractedStringsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump extracted strings internal server error response has a 4xx status code
func (o *GetMemoryDumpExtractedStringsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get memory dump extracted strings internal server error response has a 5xx status code
func (o *GetMemoryDumpExtractedStringsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get memory dump extracted strings internal server error response a status code equal to that given
func (o *GetMemoryDumpExtractedStringsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get memory dump extracted strings internal server error response
func (o *GetMemoryDumpExtractedStringsInternalServerError) Code() int {
	return 500
}

func (o *GetMemoryDumpExtractedStringsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsInternalServerError) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/extracted-strings/v1][%d] getMemoryDumpExtractedStringsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetMemoryDumpExtractedStringsInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpExtractedStringsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
