// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetMemoryDumpHexDumpReader is a Reader for the GetMemoryDumpHexDump structure.
type GetMemoryDumpHexDumpReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMemoryDumpHexDumpReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMemoryDumpHexDumpOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetMemoryDumpHexDumpBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetMemoryDumpHexDumpForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetMemoryDumpHexDumpNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetMemoryDumpHexDumpTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetMemoryDumpHexDumpInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /falconx/entities/memory-dump/hex-dump/v1] GetMemoryDumpHexDump", response, response.Code())
	}
}

// NewGetMemoryDumpHexDumpOK creates a GetMemoryDumpHexDumpOK with default headers values
func NewGetMemoryDumpHexDumpOK() *GetMemoryDumpHexDumpOK {
	return &GetMemoryDumpHexDumpOK{}
}

/*
GetMemoryDumpHexDumpOK describes a response with status code 200, with default header values.

OK
*/
type GetMemoryDumpHexDumpOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this get memory dump hex dump o k response has a 2xx status code
func (o *GetMemoryDumpHexDumpOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get memory dump hex dump o k response has a 3xx status code
func (o *GetMemoryDumpHexDumpOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump o k response has a 4xx status code
func (o *GetMemoryDumpHexDumpOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get memory dump hex dump o k response has a 5xx status code
func (o *GetMemoryDumpHexDumpOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump hex dump o k response a status code equal to that given
func (o *GetMemoryDumpHexDumpOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get memory dump hex dump o k response
func (o *GetMemoryDumpHexDumpOK) Code() int {
	return 200
}

func (o *GetMemoryDumpHexDumpOK) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpOK  %+v", 200, o.Payload)
}

func (o *GetMemoryDumpHexDumpOK) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpOK  %+v", 200, o.Payload)
}

func (o *GetMemoryDumpHexDumpOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpHexDumpBadRequest creates a GetMemoryDumpHexDumpBadRequest with default headers values
func NewGetMemoryDumpHexDumpBadRequest() *GetMemoryDumpHexDumpBadRequest {
	return &GetMemoryDumpHexDumpBadRequest{}
}

/*
GetMemoryDumpHexDumpBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetMemoryDumpHexDumpBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump hex dump bad request response has a 2xx status code
func (o *GetMemoryDumpHexDumpBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump hex dump bad request response has a 3xx status code
func (o *GetMemoryDumpHexDumpBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump bad request response has a 4xx status code
func (o *GetMemoryDumpHexDumpBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump hex dump bad request response has a 5xx status code
func (o *GetMemoryDumpHexDumpBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump hex dump bad request response a status code equal to that given
func (o *GetMemoryDumpHexDumpBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get memory dump hex dump bad request response
func (o *GetMemoryDumpHexDumpBadRequest) Code() int {
	return 400
}

func (o *GetMemoryDumpHexDumpBadRequest) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpBadRequest  %+v", 400, o.Payload)
}

func (o *GetMemoryDumpHexDumpBadRequest) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpBadRequest  %+v", 400, o.Payload)
}

func (o *GetMemoryDumpHexDumpBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpHexDumpForbidden creates a GetMemoryDumpHexDumpForbidden with default headers values
func NewGetMemoryDumpHexDumpForbidden() *GetMemoryDumpHexDumpForbidden {
	return &GetMemoryDumpHexDumpForbidden{}
}

/*
GetMemoryDumpHexDumpForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetMemoryDumpHexDumpForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get memory dump hex dump forbidden response has a 2xx status code
func (o *GetMemoryDumpHexDumpForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump hex dump forbidden response has a 3xx status code
func (o *GetMemoryDumpHexDumpForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump forbidden response has a 4xx status code
func (o *GetMemoryDumpHexDumpForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump hex dump forbidden response has a 5xx status code
func (o *GetMemoryDumpHexDumpForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump hex dump forbidden response a status code equal to that given
func (o *GetMemoryDumpHexDumpForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get memory dump hex dump forbidden response
func (o *GetMemoryDumpHexDumpForbidden) Code() int {
	return 403
}

func (o *GetMemoryDumpHexDumpForbidden) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpForbidden  %+v", 403, o.Payload)
}

func (o *GetMemoryDumpHexDumpForbidden) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpForbidden  %+v", 403, o.Payload)
}

func (o *GetMemoryDumpHexDumpForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpHexDumpNotFound creates a GetMemoryDumpHexDumpNotFound with default headers values
func NewGetMemoryDumpHexDumpNotFound() *GetMemoryDumpHexDumpNotFound {
	return &GetMemoryDumpHexDumpNotFound{}
}

/*
GetMemoryDumpHexDumpNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetMemoryDumpHexDumpNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump hex dump not found response has a 2xx status code
func (o *GetMemoryDumpHexDumpNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump hex dump not found response has a 3xx status code
func (o *GetMemoryDumpHexDumpNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump not found response has a 4xx status code
func (o *GetMemoryDumpHexDumpNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump hex dump not found response has a 5xx status code
func (o *GetMemoryDumpHexDumpNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump hex dump not found response a status code equal to that given
func (o *GetMemoryDumpHexDumpNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get memory dump hex dump not found response
func (o *GetMemoryDumpHexDumpNotFound) Code() int {
	return 404
}

func (o *GetMemoryDumpHexDumpNotFound) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpNotFound  %+v", 404, o.Payload)
}

func (o *GetMemoryDumpHexDumpNotFound) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpNotFound  %+v", 404, o.Payload)
}

func (o *GetMemoryDumpHexDumpNotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpHexDumpTooManyRequests creates a GetMemoryDumpHexDumpTooManyRequests with default headers values
func NewGetMemoryDumpHexDumpTooManyRequests() *GetMemoryDumpHexDumpTooManyRequests {
	return &GetMemoryDumpHexDumpTooManyRequests{}
}

/*
GetMemoryDumpHexDumpTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetMemoryDumpHexDumpTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get memory dump hex dump too many requests response has a 2xx status code
func (o *GetMemoryDumpHexDumpTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump hex dump too many requests response has a 3xx status code
func (o *GetMemoryDumpHexDumpTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump too many requests response has a 4xx status code
func (o *GetMemoryDumpHexDumpTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get memory dump hex dump too many requests response has a 5xx status code
func (o *GetMemoryDumpHexDumpTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get memory dump hex dump too many requests response a status code equal to that given
func (o *GetMemoryDumpHexDumpTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get memory dump hex dump too many requests response
func (o *GetMemoryDumpHexDumpTooManyRequests) Code() int {
	return 429
}

func (o *GetMemoryDumpHexDumpTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMemoryDumpHexDumpTooManyRequests) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetMemoryDumpHexDumpTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMemoryDumpHexDumpInternalServerError creates a GetMemoryDumpHexDumpInternalServerError with default headers values
func NewGetMemoryDumpHexDumpInternalServerError() *GetMemoryDumpHexDumpInternalServerError {
	return &GetMemoryDumpHexDumpInternalServerError{}
}

/*
GetMemoryDumpHexDumpInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetMemoryDumpHexDumpInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get memory dump hex dump internal server error response has a 2xx status code
func (o *GetMemoryDumpHexDumpInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get memory dump hex dump internal server error response has a 3xx status code
func (o *GetMemoryDumpHexDumpInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get memory dump hex dump internal server error response has a 4xx status code
func (o *GetMemoryDumpHexDumpInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get memory dump hex dump internal server error response has a 5xx status code
func (o *GetMemoryDumpHexDumpInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get memory dump hex dump internal server error response a status code equal to that given
func (o *GetMemoryDumpHexDumpInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get memory dump hex dump internal server error response
func (o *GetMemoryDumpHexDumpInternalServerError) Code() int {
	return 500
}

func (o *GetMemoryDumpHexDumpInternalServerError) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpInternalServerError  %+v", 500, o.Payload)
}

func (o *GetMemoryDumpHexDumpInternalServerError) String() string {
	return fmt.Sprintf("[GET /falconx/entities/memory-dump/hex-dump/v1][%d] getMemoryDumpHexDumpInternalServerError  %+v", 500, o.Payload)
}

func (o *GetMemoryDumpHexDumpInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetMemoryDumpHexDumpInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
