// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetMemoryDumpParams creates a new GetMemoryDumpParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetMemoryDumpParams() *GetMemoryDumpParams {
	return &GetMemoryDumpParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetMemoryDumpParamsWithTimeout creates a new GetMemoryDumpParams object
// with the ability to set a timeout on a request.
func NewGetMemoryDumpParamsWithTimeout(timeout time.Duration) *GetMemoryDumpParams {
	return &GetMemoryDumpParams{
		timeout: timeout,
	}
}

// NewGetMemoryDumpParamsWithContext creates a new GetMemoryDumpParams object
// with the ability to set a context for a request.
func NewGetMemoryDumpParamsWithContext(ctx context.Context) *GetMemoryDumpParams {
	return &GetMemoryDumpParams{
		Context: ctx,
	}
}

// NewGetMemoryDumpParamsWithHTTPClient creates a new GetMemoryDumpParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetMemoryDumpParamsWithHTTPClient(client *http.Client) *GetMemoryDumpParams {
	return &GetMemoryDumpParams{
		HTTPClient: client,
	}
}

/*
GetMemoryDumpParams contains all the parameters to send to the API endpoint

	for the get memory dump operation.

	Typically these are written to a http.Request.
*/
type GetMemoryDumpParams struct {

	/* AcceptEncoding.

	   Format used to compress your downloaded file. Currently, you must provide the value `gzip`, the only valid format.
	*/
	AcceptEncoding *string

	/* ID.

	   Memory dump id
	*/
	ID string

	/* Name.

	   The name given to your downloaded file.
	*/
	Name *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get memory dump params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetMemoryDumpParams) WithDefaults() *GetMemoryDumpParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get memory dump params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetMemoryDumpParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get memory dump params
func (o *GetMemoryDumpParams) WithTimeout(timeout time.Duration) *GetMemoryDumpParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get memory dump params
func (o *GetMemoryDumpParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get memory dump params
func (o *GetMemoryDumpParams) WithContext(ctx context.Context) *GetMemoryDumpParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get memory dump params
func (o *GetMemoryDumpParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get memory dump params
func (o *GetMemoryDumpParams) WithHTTPClient(client *http.Client) *GetMemoryDumpParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get memory dump params
func (o *GetMemoryDumpParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAcceptEncoding adds the acceptEncoding to the get memory dump params
func (o *GetMemoryDumpParams) WithAcceptEncoding(acceptEncoding *string) *GetMemoryDumpParams {
	o.SetAcceptEncoding(acceptEncoding)
	return o
}

// SetAcceptEncoding adds the acceptEncoding to the get memory dump params
func (o *GetMemoryDumpParams) SetAcceptEncoding(acceptEncoding *string) {
	o.AcceptEncoding = acceptEncoding
}

// WithID adds the id to the get memory dump params
func (o *GetMemoryDumpParams) WithID(id string) *GetMemoryDumpParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get memory dump params
func (o *GetMemoryDumpParams) SetID(id string) {
	o.ID = id
}

// WithName adds the name to the get memory dump params
func (o *GetMemoryDumpParams) WithName(name *string) *GetMemoryDumpParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the get memory dump params
func (o *GetMemoryDumpParams) SetName(name *string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *GetMemoryDumpParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AcceptEncoding != nil {

		// header param Accept-Encoding
		if err := r.SetHeaderParam("Accept-Encoding", *o.AcceptEncoding); err != nil {
			return err
		}
	}

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
