// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetReportsReader is a Reader for the GetReports structure.
type GetReportsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetReportsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetReportsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetReportsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetReportsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetReportsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetReportsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /falconx/entities/reports/v1] GetReports", response, response.Code())
	}
}

// NewGetReportsOK creates a GetReportsOK with default headers values
func NewGetReportsOK() *GetReportsOK {
	return &GetReportsOK{}
}

/*
GetReportsOK describes a response with status code 200, with default header values.

OK
*/
type GetReportsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxReportV1Response
}

// IsSuccess returns true when this get reports o k response has a 2xx status code
func (o *GetReportsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get reports o k response has a 3xx status code
func (o *GetReportsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get reports o k response has a 4xx status code
func (o *GetReportsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get reports o k response has a 5xx status code
func (o *GetReportsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get reports o k response a status code equal to that given
func (o *GetReportsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get reports o k response
func (o *GetReportsOK) Code() int {
	return 200
}

func (o *GetReportsOK) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsOK  %+v", 200, o.Payload)
}

func (o *GetReportsOK) String() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsOK  %+v", 200, o.Payload)
}

func (o *GetReportsOK) GetPayload() *models.FalconxReportV1Response {
	return o.Payload
}

func (o *GetReportsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxReportV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportsBadRequest creates a GetReportsBadRequest with default headers values
func NewGetReportsBadRequest() *GetReportsBadRequest {
	return &GetReportsBadRequest{}
}

/*
GetReportsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetReportsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxReportV1Response
}

// IsSuccess returns true when this get reports bad request response has a 2xx status code
func (o *GetReportsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get reports bad request response has a 3xx status code
func (o *GetReportsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get reports bad request response has a 4xx status code
func (o *GetReportsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get reports bad request response has a 5xx status code
func (o *GetReportsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get reports bad request response a status code equal to that given
func (o *GetReportsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get reports bad request response
func (o *GetReportsBadRequest) Code() int {
	return 400
}

func (o *GetReportsBadRequest) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsBadRequest  %+v", 400, o.Payload)
}

func (o *GetReportsBadRequest) String() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsBadRequest  %+v", 400, o.Payload)
}

func (o *GetReportsBadRequest) GetPayload() *models.FalconxReportV1Response {
	return o.Payload
}

func (o *GetReportsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxReportV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportsForbidden creates a GetReportsForbidden with default headers values
func NewGetReportsForbidden() *GetReportsForbidden {
	return &GetReportsForbidden{}
}

/*
GetReportsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetReportsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get reports forbidden response has a 2xx status code
func (o *GetReportsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get reports forbidden response has a 3xx status code
func (o *GetReportsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get reports forbidden response has a 4xx status code
func (o *GetReportsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get reports forbidden response has a 5xx status code
func (o *GetReportsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get reports forbidden response a status code equal to that given
func (o *GetReportsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get reports forbidden response
func (o *GetReportsForbidden) Code() int {
	return 403
}

func (o *GetReportsForbidden) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsForbidden  %+v", 403, o.Payload)
}

func (o *GetReportsForbidden) String() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsForbidden  %+v", 403, o.Payload)
}

func (o *GetReportsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetReportsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportsTooManyRequests creates a GetReportsTooManyRequests with default headers values
func NewGetReportsTooManyRequests() *GetReportsTooManyRequests {
	return &GetReportsTooManyRequests{}
}

/*
GetReportsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetReportsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get reports too many requests response has a 2xx status code
func (o *GetReportsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get reports too many requests response has a 3xx status code
func (o *GetReportsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get reports too many requests response has a 4xx status code
func (o *GetReportsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get reports too many requests response has a 5xx status code
func (o *GetReportsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get reports too many requests response a status code equal to that given
func (o *GetReportsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get reports too many requests response
func (o *GetReportsTooManyRequests) Code() int {
	return 429
}

func (o *GetReportsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetReportsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetReportsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetReportsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetReportsInternalServerError creates a GetReportsInternalServerError with default headers values
func NewGetReportsInternalServerError() *GetReportsInternalServerError {
	return &GetReportsInternalServerError{}
}

/*
GetReportsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetReportsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxReportV1Response
}

// IsSuccess returns true when this get reports internal server error response has a 2xx status code
func (o *GetReportsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get reports internal server error response has a 3xx status code
func (o *GetReportsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get reports internal server error response has a 4xx status code
func (o *GetReportsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get reports internal server error response has a 5xx status code
func (o *GetReportsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get reports internal server error response a status code equal to that given
func (o *GetReportsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get reports internal server error response
func (o *GetReportsInternalServerError) Code() int {
	return 500
}

func (o *GetReportsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReportsInternalServerError) String() string {
	return fmt.Sprintf("[GET /falconx/entities/reports/v1][%d] getReportsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetReportsInternalServerError) GetPayload() *models.FalconxReportV1Response {
	return o.Payload
}

func (o *GetReportsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxReportV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
