// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetSampleV2Params creates a new GetSampleV2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSampleV2Params() *GetSampleV2Params {
	return &GetSampleV2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSampleV2ParamsWithTimeout creates a new GetSampleV2Params object
// with the ability to set a timeout on a request.
func NewGetSampleV2ParamsWithTimeout(timeout time.Duration) *GetSampleV2Params {
	return &GetSampleV2Params{
		timeout: timeout,
	}
}

// NewGetSampleV2ParamsWithContext creates a new GetSampleV2Params object
// with the ability to set a context for a request.
func NewGetSampleV2ParamsWithContext(ctx context.Context) *GetSampleV2Params {
	return &GetSampleV2Params{
		Context: ctx,
	}
}

// NewGetSampleV2ParamsWithHTTPClient creates a new GetSampleV2Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetSampleV2ParamsWithHTTPClient(client *http.Client) *GetSampleV2Params {
	return &GetSampleV2Params{
		HTTPClient: client,
	}
}

/*
GetSampleV2Params contains all the parameters to send to the API endpoint

	for the get sample v2 operation.

	Typically these are written to a http.Request.
*/
type GetSampleV2Params struct {

	/* Ids.

	   The file SHA256.
	*/
	Ids string

	/* PasswordProtected.

	   Flag whether the sample should be zipped and password protected with pass='infected'
	*/
	PasswordProtected *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get sample v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSampleV2Params) WithDefaults() *GetSampleV2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get sample v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSampleV2Params) SetDefaults() {
	var (
		passwordProtectedDefault = bool(false)
	)

	val := GetSampleV2Params{
		PasswordProtected: &passwordProtectedDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get sample v2 params
func (o *GetSampleV2Params) WithTimeout(timeout time.Duration) *GetSampleV2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get sample v2 params
func (o *GetSampleV2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get sample v2 params
func (o *GetSampleV2Params) WithContext(ctx context.Context) *GetSampleV2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get sample v2 params
func (o *GetSampleV2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get sample v2 params
func (o *GetSampleV2Params) WithHTTPClient(client *http.Client) *GetSampleV2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get sample v2 params
func (o *GetSampleV2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get sample v2 params
func (o *GetSampleV2Params) WithIds(ids string) *GetSampleV2Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get sample v2 params
func (o *GetSampleV2Params) SetIds(ids string) {
	o.Ids = ids
}

// WithPasswordProtected adds the passwordProtected to the get sample v2 params
func (o *GetSampleV2Params) WithPasswordProtected(passwordProtected *bool) *GetSampleV2Params {
	o.SetPasswordProtected(passwordProtected)
	return o
}

// SetPasswordProtected adds the passwordProtected to the get sample v2 params
func (o *GetSampleV2Params) SetPasswordProtected(passwordProtected *bool) {
	o.PasswordProtected = passwordProtected
}

// WriteToRequest writes these params to a swagger request
func (o *GetSampleV2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param ids
	qrIds := o.Ids
	qIds := qrIds
	if qIds != "" {

		if err := r.SetQueryParam("ids", qIds); err != nil {
			return err
		}
	}

	if o.PasswordProtected != nil {

		// query param password_protected
		var qrPasswordProtected bool

		if o.PasswordProtected != nil {
			qrPasswordProtected = *o.PasswordProtected
		}
		qPasswordProtected := swag.FormatBool(qrPasswordProtected)
		if qPasswordProtected != "" {

			if err := r.SetQueryParam("password_protected", qPasswordProtected); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
