// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetSubmissionsParams creates a new GetSubmissionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSubmissionsParams() *GetSubmissionsParams {
	return &GetSubmissionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSubmissionsParamsWithTimeout creates a new GetSubmissionsParams object
// with the ability to set a timeout on a request.
func NewGetSubmissionsParamsWithTimeout(timeout time.Duration) *GetSubmissionsParams {
	return &GetSubmissionsParams{
		timeout: timeout,
	}
}

// NewGetSubmissionsParamsWithContext creates a new GetSubmissionsParams object
// with the ability to set a context for a request.
func NewGetSubmissionsParamsWithContext(ctx context.Context) *GetSubmissionsParams {
	return &GetSubmissionsParams{
		Context: ctx,
	}
}

// NewGetSubmissionsParamsWithHTTPClient creates a new GetSubmissionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetSubmissionsParamsWithHTTPClient(client *http.Client) *GetSubmissionsParams {
	return &GetSubmissionsParams{
		HTTPClient: client,
	}
}

/*
GetSubmissionsParams contains all the parameters to send to the API endpoint

	for the get submissions operation.

	Typically these are written to a http.Request.
*/
type GetSubmissionsParams struct {

	/* Ids.

	   ID of a submitted malware sample. Find a submission ID from the response when submitting a malware sample or search with `/falconx/queries/submissions/v1`.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get submissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSubmissionsParams) WithDefaults() *GetSubmissionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get submissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSubmissionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get submissions params
func (o *GetSubmissionsParams) WithTimeout(timeout time.Duration) *GetSubmissionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get submissions params
func (o *GetSubmissionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get submissions params
func (o *GetSubmissionsParams) WithContext(ctx context.Context) *GetSubmissionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get submissions params
func (o *GetSubmissionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get submissions params
func (o *GetSubmissionsParams) WithHTTPClient(client *http.Client) *GetSubmissionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get submissions params
func (o *GetSubmissionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get submissions params
func (o *GetSubmissionsParams) WithIds(ids []string) *GetSubmissionsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get submissions params
func (o *GetSubmissionsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetSubmissionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetSubmissions binds the parameter ids
func (o *GetSubmissionsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
