// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetSummaryReportsParams creates a new GetSummaryReportsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSummaryReportsParams() *GetSummaryReportsParams {
	return &GetSummaryReportsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSummaryReportsParamsWithTimeout creates a new GetSummaryReportsParams object
// with the ability to set a timeout on a request.
func NewGetSummaryReportsParamsWithTimeout(timeout time.Duration) *GetSummaryReportsParams {
	return &GetSummaryReportsParams{
		timeout: timeout,
	}
}

// NewGetSummaryReportsParamsWithContext creates a new GetSummaryReportsParams object
// with the ability to set a context for a request.
func NewGetSummaryReportsParamsWithContext(ctx context.Context) *GetSummaryReportsParams {
	return &GetSummaryReportsParams{
		Context: ctx,
	}
}

// NewGetSummaryReportsParamsWithHTTPClient creates a new GetSummaryReportsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetSummaryReportsParamsWithHTTPClient(client *http.Client) *GetSummaryReportsParams {
	return &GetSummaryReportsParams{
		HTTPClient: client,
	}
}

/*
GetSummaryReportsParams contains all the parameters to send to the API endpoint

	for the get summary reports operation.

	Typically these are written to a http.Request.
*/
type GetSummaryReportsParams struct {

	/* Ids.

	   ID of a summary. Find a summary ID from the response when submitting a malware sample or search with `/falconx/queries/reports/v1`.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get summary reports params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSummaryReportsParams) WithDefaults() *GetSummaryReportsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get summary reports params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSummaryReportsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get summary reports params
func (o *GetSummaryReportsParams) WithTimeout(timeout time.Duration) *GetSummaryReportsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get summary reports params
func (o *GetSummaryReportsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get summary reports params
func (o *GetSummaryReportsParams) WithContext(ctx context.Context) *GetSummaryReportsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get summary reports params
func (o *GetSummaryReportsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get summary reports params
func (o *GetSummaryReportsParams) WithHTTPClient(client *http.Client) *GetSummaryReportsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get summary reports params
func (o *GetSummaryReportsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get summary reports params
func (o *GetSummaryReportsParams) WithIds(ids []string) *GetSummaryReportsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get summary reports params
func (o *GetSummaryReportsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetSummaryReportsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetSummaryReports binds the parameter ids
func (o *GetSummaryReportsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "csv"
	idsIS := swag.JoinByFormat(idsIC, "csv")

	return idsIS
}
