// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryReportsReader is a Reader for the QueryReports structure.
type QueryReportsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryReportsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryReportsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryReportsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryReportsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryReportsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryReportsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /falconx/queries/reports/v1] QueryReports", response, response.Code())
	}
}

// NewQueryReportsOK creates a QueryReportsOK with default headers values
func NewQueryReportsOK() *QueryReportsOK {
	return &QueryReportsOK{}
}

/*
QueryReportsOK describes a response with status code 200, with default header values.

OK
*/
type QueryReportsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this query reports o k response has a 2xx status code
func (o *QueryReportsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query reports o k response has a 3xx status code
func (o *QueryReportsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query reports o k response has a 4xx status code
func (o *QueryReportsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query reports o k response has a 5xx status code
func (o *QueryReportsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query reports o k response a status code equal to that given
func (o *QueryReportsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query reports o k response
func (o *QueryReportsOK) Code() int {
	return 200
}

func (o *QueryReportsOK) Error() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsOK  %+v", 200, o.Payload)
}

func (o *QueryReportsOK) String() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsOK  %+v", 200, o.Payload)
}

func (o *QueryReportsOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *QueryReportsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryReportsBadRequest creates a QueryReportsBadRequest with default headers values
func NewQueryReportsBadRequest() *QueryReportsBadRequest {
	return &QueryReportsBadRequest{}
}

/*
QueryReportsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryReportsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this query reports bad request response has a 2xx status code
func (o *QueryReportsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query reports bad request response has a 3xx status code
func (o *QueryReportsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query reports bad request response has a 4xx status code
func (o *QueryReportsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query reports bad request response has a 5xx status code
func (o *QueryReportsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query reports bad request response a status code equal to that given
func (o *QueryReportsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query reports bad request response
func (o *QueryReportsBadRequest) Code() int {
	return 400
}

func (o *QueryReportsBadRequest) Error() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryReportsBadRequest) String() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryReportsBadRequest) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *QueryReportsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryReportsForbidden creates a QueryReportsForbidden with default headers values
func NewQueryReportsForbidden() *QueryReportsForbidden {
	return &QueryReportsForbidden{}
}

/*
QueryReportsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryReportsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query reports forbidden response has a 2xx status code
func (o *QueryReportsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query reports forbidden response has a 3xx status code
func (o *QueryReportsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query reports forbidden response has a 4xx status code
func (o *QueryReportsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query reports forbidden response has a 5xx status code
func (o *QueryReportsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query reports forbidden response a status code equal to that given
func (o *QueryReportsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query reports forbidden response
func (o *QueryReportsForbidden) Code() int {
	return 403
}

func (o *QueryReportsForbidden) Error() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsForbidden  %+v", 403, o.Payload)
}

func (o *QueryReportsForbidden) String() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsForbidden  %+v", 403, o.Payload)
}

func (o *QueryReportsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryReportsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryReportsTooManyRequests creates a QueryReportsTooManyRequests with default headers values
func NewQueryReportsTooManyRequests() *QueryReportsTooManyRequests {
	return &QueryReportsTooManyRequests{}
}

/*
QueryReportsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryReportsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query reports too many requests response has a 2xx status code
func (o *QueryReportsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query reports too many requests response has a 3xx status code
func (o *QueryReportsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query reports too many requests response has a 4xx status code
func (o *QueryReportsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query reports too many requests response has a 5xx status code
func (o *QueryReportsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query reports too many requests response a status code equal to that given
func (o *QueryReportsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query reports too many requests response
func (o *QueryReportsTooManyRequests) Code() int {
	return 429
}

func (o *QueryReportsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryReportsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryReportsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryReportsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryReportsInternalServerError creates a QueryReportsInternalServerError with default headers values
func NewQueryReportsInternalServerError() *QueryReportsInternalServerError {
	return &QueryReportsInternalServerError{}
}

/*
QueryReportsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryReportsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this query reports internal server error response has a 2xx status code
func (o *QueryReportsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query reports internal server error response has a 3xx status code
func (o *QueryReportsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query reports internal server error response has a 4xx status code
func (o *QueryReportsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query reports internal server error response has a 5xx status code
func (o *QueryReportsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query reports internal server error response a status code equal to that given
func (o *QueryReportsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query reports internal server error response
func (o *QueryReportsInternalServerError) Code() int {
	return 500
}

func (o *QueryReportsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryReportsInternalServerError) String() string {
	return fmt.Sprintf("[GET /falconx/queries/reports/v1][%d] queryReportsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryReportsInternalServerError) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *QueryReportsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
