// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewSubmitParams creates a new SubmitParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSubmitParams() *SubmitParams {
	return &SubmitParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSubmitParamsWithTimeout creates a new SubmitParams object
// with the ability to set a timeout on a request.
func NewSubmitParamsWithTimeout(timeout time.Duration) *SubmitParams {
	return &SubmitParams{
		timeout: timeout,
	}
}

// NewSubmitParamsWithContext creates a new SubmitParams object
// with the ability to set a context for a request.
func NewSubmitParamsWithContext(ctx context.Context) *SubmitParams {
	return &SubmitParams{
		Context: ctx,
	}
}

// NewSubmitParamsWithHTTPClient creates a new SubmitParams object
// with the ability to set a custom HTTPClient for a request.
func NewSubmitParamsWithHTTPClient(client *http.Client) *SubmitParams {
	return &SubmitParams{
		HTTPClient: client,
	}
}

/*
SubmitParams contains all the parameters to send to the API endpoint

	for the submit operation.

	Typically these are written to a http.Request.
*/
type SubmitParams struct {

	/* Body.

	     Submit either a URL or a sample SHA256 for sandbox analysis. The sample file must have been previously uploaded through `/samples/entities/samples/v2`. You must specify a JSON object that includes the `falconx.SubmissionParametersV1` key/value pairs shown below.

	**`environment_id`**: Specifies the sandbox environment used for analysis. Values:

	- `300`: Linux Ubuntu 16.04, 64-bit
	- `200`: Android (static analysis)
	- `160`: Windows 10, 64-bit
	- `110`: Windows 7, 64-bit
	- `100`: Windows 7, 32-bit

	**`sha256`** ID of the sample, which is a SHA256 hash value. Find a sample ID from the response when uploading a malware sample or search with `/falconx/queries/submissions/v1`.The `url` parameter must be unset if `sha256` is used.

	**`url`** A web page or file URL. It can be HTTP(S) or FTP. The `sha256` parameter must be unset if `url` is used.

	**`action_script`** (optional): Runtime script for sandbox analysis. Values:

	- `default`
	- `default_maxantievasion`
	- `default_randomfiles`
	- `default_randomtheme`
	- `default_openie`

	**`command_line`** (optional): Command line script passed to the submitted file at runtime. Max length: 2048 characters

	**`document_password`** (optional): Auto-filled for Adobe or Office files that prompt for a password. Max length: 32 characters

	**`enable_tor`** (optional): Deprecated, please use `network_settings` instead. If `true`, sandbox analysis routes network traffic via TOR. Default: `false`.

	**`network_settings`** (optional): Specifies the sandbox network_settings used for analysis. Values:

	- `default`: Fully operating network
	- `tor`: Route network traffic via TOR
	- `simulated`: Simulate network traffic
	- `offline`: No network traffic

	**`submit_name`** (optional): Name of the malware sample that's used for file type detection and analysis

	**`system_date`** (optional): Set a custom date in the format `yyyy-MM-dd` for the sandbox environment

	**`system_time`** (optional): Set a custom time in the format `HH:mm` for the sandbox environment.
	*/
	Body *models.FalconxSubmissionParametersV1

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the submit params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SubmitParams) WithDefaults() *SubmitParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the submit params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SubmitParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the submit params
func (o *SubmitParams) WithTimeout(timeout time.Duration) *SubmitParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the submit params
func (o *SubmitParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the submit params
func (o *SubmitParams) WithContext(ctx context.Context) *SubmitParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the submit params
func (o *SubmitParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the submit params
func (o *SubmitParams) WithHTTPClient(client *http.Client) *SubmitParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the submit params
func (o *SubmitParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the submit params
func (o *SubmitParams) WithBody(body *models.FalconxSubmissionParametersV1) *SubmitParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the submit params
func (o *SubmitParams) SetBody(body *models.FalconxSubmissionParametersV1) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *SubmitParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
