// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// SubmitReader is a Reader for the Submit structure.
type SubmitReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SubmitReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSubmitOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSubmitBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSubmitForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewSubmitTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSubmitInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /falconx/entities/submissions/v1] Submit", response, response.Code())
	}
}

// NewSubmitOK creates a SubmitOK with default headers values
func NewSubmitOK() *SubmitOK {
	return &SubmitOK{}
}

/*
SubmitOK describes a response with status code 200, with default header values.

OK
*/
type SubmitOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxSubmissionV1Response
}

// IsSuccess returns true when this submit o k response has a 2xx status code
func (o *SubmitOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this submit o k response has a 3xx status code
func (o *SubmitOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this submit o k response has a 4xx status code
func (o *SubmitOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this submit o k response has a 5xx status code
func (o *SubmitOK) IsServerError() bool {
	return false
}

// IsCode returns true when this submit o k response a status code equal to that given
func (o *SubmitOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the submit o k response
func (o *SubmitOK) Code() int {
	return 200
}

func (o *SubmitOK) Error() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitOK  %+v", 200, o.Payload)
}

func (o *SubmitOK) String() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitOK  %+v", 200, o.Payload)
}

func (o *SubmitOK) GetPayload() *models.FalconxSubmissionV1Response {
	return o.Payload
}

func (o *SubmitOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxSubmissionV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSubmitBadRequest creates a SubmitBadRequest with default headers values
func NewSubmitBadRequest() *SubmitBadRequest {
	return &SubmitBadRequest{}
}

/*
SubmitBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type SubmitBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxSubmissionV1Response
}

// IsSuccess returns true when this submit bad request response has a 2xx status code
func (o *SubmitBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this submit bad request response has a 3xx status code
func (o *SubmitBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this submit bad request response has a 4xx status code
func (o *SubmitBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this submit bad request response has a 5xx status code
func (o *SubmitBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this submit bad request response a status code equal to that given
func (o *SubmitBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the submit bad request response
func (o *SubmitBadRequest) Code() int {
	return 400
}

func (o *SubmitBadRequest) Error() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitBadRequest  %+v", 400, o.Payload)
}

func (o *SubmitBadRequest) String() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitBadRequest  %+v", 400, o.Payload)
}

func (o *SubmitBadRequest) GetPayload() *models.FalconxSubmissionV1Response {
	return o.Payload
}

func (o *SubmitBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxSubmissionV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSubmitForbidden creates a SubmitForbidden with default headers values
func NewSubmitForbidden() *SubmitForbidden {
	return &SubmitForbidden{}
}

/*
SubmitForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type SubmitForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this submit forbidden response has a 2xx status code
func (o *SubmitForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this submit forbidden response has a 3xx status code
func (o *SubmitForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this submit forbidden response has a 4xx status code
func (o *SubmitForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this submit forbidden response has a 5xx status code
func (o *SubmitForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this submit forbidden response a status code equal to that given
func (o *SubmitForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the submit forbidden response
func (o *SubmitForbidden) Code() int {
	return 403
}

func (o *SubmitForbidden) Error() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitForbidden  %+v", 403, o.Payload)
}

func (o *SubmitForbidden) String() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitForbidden  %+v", 403, o.Payload)
}

func (o *SubmitForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *SubmitForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSubmitTooManyRequests creates a SubmitTooManyRequests with default headers values
func NewSubmitTooManyRequests() *SubmitTooManyRequests {
	return &SubmitTooManyRequests{}
}

/*
SubmitTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type SubmitTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.FalconxSubmissionV1Response
}

// IsSuccess returns true when this submit too many requests response has a 2xx status code
func (o *SubmitTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this submit too many requests response has a 3xx status code
func (o *SubmitTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this submit too many requests response has a 4xx status code
func (o *SubmitTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this submit too many requests response has a 5xx status code
func (o *SubmitTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this submit too many requests response a status code equal to that given
func (o *SubmitTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the submit too many requests response
func (o *SubmitTooManyRequests) Code() int {
	return 429
}

func (o *SubmitTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitTooManyRequests  %+v", 429, o.Payload)
}

func (o *SubmitTooManyRequests) String() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitTooManyRequests  %+v", 429, o.Payload)
}

func (o *SubmitTooManyRequests) GetPayload() *models.FalconxSubmissionV1Response {
	return o.Payload
}

func (o *SubmitTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.FalconxSubmissionV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSubmitInternalServerError creates a SubmitInternalServerError with default headers values
func NewSubmitInternalServerError() *SubmitInternalServerError {
	return &SubmitInternalServerError{}
}

/*
SubmitInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type SubmitInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FalconxSubmissionV1Response
}

// IsSuccess returns true when this submit internal server error response has a 2xx status code
func (o *SubmitInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this submit internal server error response has a 3xx status code
func (o *SubmitInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this submit internal server error response has a 4xx status code
func (o *SubmitInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this submit internal server error response has a 5xx status code
func (o *SubmitInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this submit internal server error response a status code equal to that given
func (o *SubmitInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the submit internal server error response
func (o *SubmitInternalServerError) Code() int {
	return 500
}

func (o *SubmitInternalServerError) Error() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitInternalServerError  %+v", 500, o.Payload)
}

func (o *SubmitInternalServerError) String() string {
	return fmt.Sprintf("[POST /falconx/entities/submissions/v1][%d] submitInternalServerError  %+v", 500, o.Payload)
}

func (o *SubmitInternalServerError) GetPayload() *models.FalconxSubmissionV1Response {
	return o.Payload
}

func (o *SubmitInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FalconxSubmissionV1Response)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
