// Code generated by go-swagger; DO NOT EDIT.

package falconx_sandbox

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UploadSampleV2Reader is a Reader for the UploadSampleV2 structure.
type UploadSampleV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UploadSampleV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUploadSampleV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUploadSampleV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUploadSampleV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUploadSampleV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUploadSampleV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /samples/entities/samples/v2] UploadSampleV2", response, response.Code())
	}
}

// NewUploadSampleV2OK creates a UploadSampleV2OK with default headers values
func NewUploadSampleV2OK() *UploadSampleV2OK {
	return &UploadSampleV2OK{}
}

/*
UploadSampleV2OK describes a response with status code 200, with default header values.

OK
*/
type UploadSampleV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientSampleMetadataResponseV2
}

// IsSuccess returns true when this upload sample v2 o k response has a 2xx status code
func (o *UploadSampleV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this upload sample v2 o k response has a 3xx status code
func (o *UploadSampleV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload sample v2 o k response has a 4xx status code
func (o *UploadSampleV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this upload sample v2 o k response has a 5xx status code
func (o *UploadSampleV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this upload sample v2 o k response a status code equal to that given
func (o *UploadSampleV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the upload sample v2 o k response
func (o *UploadSampleV2OK) Code() int {
	return 200
}

func (o *UploadSampleV2OK) Error() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2OK  %+v", 200, o.Payload)
}

func (o *UploadSampleV2OK) String() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2OK  %+v", 200, o.Payload)
}

func (o *UploadSampleV2OK) GetPayload() *models.ClientSampleMetadataResponseV2 {
	return o.Payload
}

func (o *UploadSampleV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientSampleMetadataResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSampleV2BadRequest creates a UploadSampleV2BadRequest with default headers values
func NewUploadSampleV2BadRequest() *UploadSampleV2BadRequest {
	return &UploadSampleV2BadRequest{}
}

/*
UploadSampleV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UploadSampleV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientSampleMetadataResponseV2
}

// IsSuccess returns true when this upload sample v2 bad request response has a 2xx status code
func (o *UploadSampleV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload sample v2 bad request response has a 3xx status code
func (o *UploadSampleV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload sample v2 bad request response has a 4xx status code
func (o *UploadSampleV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload sample v2 bad request response has a 5xx status code
func (o *UploadSampleV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this upload sample v2 bad request response a status code equal to that given
func (o *UploadSampleV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the upload sample v2 bad request response
func (o *UploadSampleV2BadRequest) Code() int {
	return 400
}

func (o *UploadSampleV2BadRequest) Error() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2BadRequest  %+v", 400, o.Payload)
}

func (o *UploadSampleV2BadRequest) String() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2BadRequest  %+v", 400, o.Payload)
}

func (o *UploadSampleV2BadRequest) GetPayload() *models.ClientSampleMetadataResponseV2 {
	return o.Payload
}

func (o *UploadSampleV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientSampleMetadataResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSampleV2Forbidden creates a UploadSampleV2Forbidden with default headers values
func NewUploadSampleV2Forbidden() *UploadSampleV2Forbidden {
	return &UploadSampleV2Forbidden{}
}

/*
UploadSampleV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UploadSampleV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this upload sample v2 forbidden response has a 2xx status code
func (o *UploadSampleV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload sample v2 forbidden response has a 3xx status code
func (o *UploadSampleV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload sample v2 forbidden response has a 4xx status code
func (o *UploadSampleV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload sample v2 forbidden response has a 5xx status code
func (o *UploadSampleV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this upload sample v2 forbidden response a status code equal to that given
func (o *UploadSampleV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the upload sample v2 forbidden response
func (o *UploadSampleV2Forbidden) Code() int {
	return 403
}

func (o *UploadSampleV2Forbidden) Error() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2Forbidden  %+v", 403, o.Payload)
}

func (o *UploadSampleV2Forbidden) String() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2Forbidden  %+v", 403, o.Payload)
}

func (o *UploadSampleV2Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UploadSampleV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSampleV2TooManyRequests creates a UploadSampleV2TooManyRequests with default headers values
func NewUploadSampleV2TooManyRequests() *UploadSampleV2TooManyRequests {
	return &UploadSampleV2TooManyRequests{}
}

/*
UploadSampleV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UploadSampleV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this upload sample v2 too many requests response has a 2xx status code
func (o *UploadSampleV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload sample v2 too many requests response has a 3xx status code
func (o *UploadSampleV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload sample v2 too many requests response has a 4xx status code
func (o *UploadSampleV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this upload sample v2 too many requests response has a 5xx status code
func (o *UploadSampleV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this upload sample v2 too many requests response a status code equal to that given
func (o *UploadSampleV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the upload sample v2 too many requests response
func (o *UploadSampleV2TooManyRequests) Code() int {
	return 429
}

func (o *UploadSampleV2TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *UploadSampleV2TooManyRequests) String() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *UploadSampleV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UploadSampleV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUploadSampleV2InternalServerError creates a UploadSampleV2InternalServerError with default headers values
func NewUploadSampleV2InternalServerError() *UploadSampleV2InternalServerError {
	return &UploadSampleV2InternalServerError{}
}

/*
UploadSampleV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UploadSampleV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientSampleMetadataResponseV2
}

// IsSuccess returns true when this upload sample v2 internal server error response has a 2xx status code
func (o *UploadSampleV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this upload sample v2 internal server error response has a 3xx status code
func (o *UploadSampleV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this upload sample v2 internal server error response has a 4xx status code
func (o *UploadSampleV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this upload sample v2 internal server error response has a 5xx status code
func (o *UploadSampleV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this upload sample v2 internal server error response a status code equal to that given
func (o *UploadSampleV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the upload sample v2 internal server error response
func (o *UploadSampleV2InternalServerError) Code() int {
	return 500
}

func (o *UploadSampleV2InternalServerError) Error() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2InternalServerError  %+v", 500, o.Payload)
}

func (o *UploadSampleV2InternalServerError) String() string {
	return fmt.Sprintf("[POST /samples/entities/samples/v2][%d] uploadSampleV2InternalServerError  %+v", 500, o.Payload)
}

func (o *UploadSampleV2InternalServerError) GetPayload() *models.ClientSampleMetadataResponseV2 {
	return o.Payload
}

func (o *UploadSampleV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientSampleMetadataResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
