// Code generated by go-swagger; DO NOT EDIT.

package field_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// FdrschemaEntitiesFieldGetReader is a Reader for the FdrschemaEntitiesFieldGet structure.
type FdrschemaEntitiesFieldGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FdrschemaEntitiesFieldGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFdrschemaEntitiesFieldGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewFdrschemaEntitiesFieldGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewFdrschemaEntitiesFieldGetTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fdr/entities/schema-fields/v1] fdrschema.entities.field.get", response, response.Code())
	}
}

// NewFdrschemaEntitiesFieldGetOK creates a FdrschemaEntitiesFieldGetOK with default headers values
func NewFdrschemaEntitiesFieldGetOK() *FdrschemaEntitiesFieldGetOK {
	return &FdrschemaEntitiesFieldGetOK{}
}

/*
FdrschemaEntitiesFieldGetOK describes a response with status code 200, with default header values.

OK
*/
type FdrschemaEntitiesFieldGetOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SchemaSensorFieldResponseV1
}

// IsSuccess returns true when this fdrschema entities field get o k response has a 2xx status code
func (o *FdrschemaEntitiesFieldGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fdrschema entities field get o k response has a 3xx status code
func (o *FdrschemaEntitiesFieldGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema entities field get o k response has a 4xx status code
func (o *FdrschemaEntitiesFieldGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fdrschema entities field get o k response has a 5xx status code
func (o *FdrschemaEntitiesFieldGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema entities field get o k response a status code equal to that given
func (o *FdrschemaEntitiesFieldGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fdrschema entities field get o k response
func (o *FdrschemaEntitiesFieldGetOK) Code() int {
	return 200
}

func (o *FdrschemaEntitiesFieldGetOK) Error() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetOK) String() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetOK) GetPayload() *models.SchemaSensorFieldResponseV1 {
	return o.Payload
}

func (o *FdrschemaEntitiesFieldGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SchemaSensorFieldResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaEntitiesFieldGetForbidden creates a FdrschemaEntitiesFieldGetForbidden with default headers values
func NewFdrschemaEntitiesFieldGetForbidden() *FdrschemaEntitiesFieldGetForbidden {
	return &FdrschemaEntitiesFieldGetForbidden{}
}

/*
FdrschemaEntitiesFieldGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type FdrschemaEntitiesFieldGetForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema entities field get forbidden response has a 2xx status code
func (o *FdrschemaEntitiesFieldGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema entities field get forbidden response has a 3xx status code
func (o *FdrschemaEntitiesFieldGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema entities field get forbidden response has a 4xx status code
func (o *FdrschemaEntitiesFieldGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema entities field get forbidden response has a 5xx status code
func (o *FdrschemaEntitiesFieldGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema entities field get forbidden response a status code equal to that given
func (o *FdrschemaEntitiesFieldGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the fdrschema entities field get forbidden response
func (o *FdrschemaEntitiesFieldGetForbidden) Code() int {
	return 403
}

func (o *FdrschemaEntitiesFieldGetForbidden) Error() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetForbidden) String() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaEntitiesFieldGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaEntitiesFieldGetTooManyRequests creates a FdrschemaEntitiesFieldGetTooManyRequests with default headers values
func NewFdrschemaEntitiesFieldGetTooManyRequests() *FdrschemaEntitiesFieldGetTooManyRequests {
	return &FdrschemaEntitiesFieldGetTooManyRequests{}
}

/*
FdrschemaEntitiesFieldGetTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type FdrschemaEntitiesFieldGetTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema entities field get too many requests response has a 2xx status code
func (o *FdrschemaEntitiesFieldGetTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema entities field get too many requests response has a 3xx status code
func (o *FdrschemaEntitiesFieldGetTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema entities field get too many requests response has a 4xx status code
func (o *FdrschemaEntitiesFieldGetTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema entities field get too many requests response has a 5xx status code
func (o *FdrschemaEntitiesFieldGetTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema entities field get too many requests response a status code equal to that given
func (o *FdrschemaEntitiesFieldGetTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the fdrschema entities field get too many requests response
func (o *FdrschemaEntitiesFieldGetTooManyRequests) Code() int {
	return 429
}

func (o *FdrschemaEntitiesFieldGetTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fdr/entities/schema-fields/v1][%d] fdrschemaEntitiesFieldGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaEntitiesFieldGetTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaEntitiesFieldGetTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
