// Code generated by go-swagger; DO NOT EDIT.

package field_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// FdrschemaQueriesFieldGetReader is a Reader for the FdrschemaQueriesFieldGet structure.
type FdrschemaQueriesFieldGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FdrschemaQueriesFieldGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFdrschemaQueriesFieldGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewFdrschemaQueriesFieldGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewFdrschemaQueriesFieldGetTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fdr/queries/schema-fields/v1] fdrschema.queries.field.get", response, response.Code())
	}
}

// NewFdrschemaQueriesFieldGetOK creates a FdrschemaQueriesFieldGetOK with default headers values
func NewFdrschemaQueriesFieldGetOK() *FdrschemaQueriesFieldGetOK {
	return &FdrschemaQueriesFieldGetOK{}
}

/*
FdrschemaQueriesFieldGetOK describes a response with status code 200, with default header values.

OK
*/
type FdrschemaQueriesFieldGetOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this fdrschema queries field get o k response has a 2xx status code
func (o *FdrschemaQueriesFieldGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fdrschema queries field get o k response has a 3xx status code
func (o *FdrschemaQueriesFieldGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries field get o k response has a 4xx status code
func (o *FdrschemaQueriesFieldGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fdrschema queries field get o k response has a 5xx status code
func (o *FdrschemaQueriesFieldGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries field get o k response a status code equal to that given
func (o *FdrschemaQueriesFieldGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fdrschema queries field get o k response
func (o *FdrschemaQueriesFieldGetOK) Code() int {
	return 200
}

func (o *FdrschemaQueriesFieldGetOK) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaQueriesFieldGetOK) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetOK  %+v", 200, o.Payload)
}

func (o *FdrschemaQueriesFieldGetOK) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *FdrschemaQueriesFieldGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaQueriesFieldGetForbidden creates a FdrschemaQueriesFieldGetForbidden with default headers values
func NewFdrschemaQueriesFieldGetForbidden() *FdrschemaQueriesFieldGetForbidden {
	return &FdrschemaQueriesFieldGetForbidden{}
}

/*
FdrschemaQueriesFieldGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type FdrschemaQueriesFieldGetForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema queries field get forbidden response has a 2xx status code
func (o *FdrschemaQueriesFieldGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema queries field get forbidden response has a 3xx status code
func (o *FdrschemaQueriesFieldGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries field get forbidden response has a 4xx status code
func (o *FdrschemaQueriesFieldGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema queries field get forbidden response has a 5xx status code
func (o *FdrschemaQueriesFieldGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries field get forbidden response a status code equal to that given
func (o *FdrschemaQueriesFieldGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the fdrschema queries field get forbidden response
func (o *FdrschemaQueriesFieldGetForbidden) Code() int {
	return 403
}

func (o *FdrschemaQueriesFieldGetForbidden) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaQueriesFieldGetForbidden) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetForbidden  %+v", 403, o.Payload)
}

func (o *FdrschemaQueriesFieldGetForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaQueriesFieldGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFdrschemaQueriesFieldGetTooManyRequests creates a FdrschemaQueriesFieldGetTooManyRequests with default headers values
func NewFdrschemaQueriesFieldGetTooManyRequests() *FdrschemaQueriesFieldGetTooManyRequests {
	return &FdrschemaQueriesFieldGetTooManyRequests{}
}

/*
FdrschemaQueriesFieldGetTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type FdrschemaQueriesFieldGetTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this fdrschema queries field get too many requests response has a 2xx status code
func (o *FdrschemaQueriesFieldGetTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this fdrschema queries field get too many requests response has a 3xx status code
func (o *FdrschemaQueriesFieldGetTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fdrschema queries field get too many requests response has a 4xx status code
func (o *FdrschemaQueriesFieldGetTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this fdrschema queries field get too many requests response has a 5xx status code
func (o *FdrschemaQueriesFieldGetTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this fdrschema queries field get too many requests response a status code equal to that given
func (o *FdrschemaQueriesFieldGetTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the fdrschema queries field get too many requests response
func (o *FdrschemaQueriesFieldGetTooManyRequests) Code() int {
	return 429
}

func (o *FdrschemaQueriesFieldGetTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaQueriesFieldGetTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fdr/queries/schema-fields/v1][%d] fdrschemaQueriesFieldGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *FdrschemaQueriesFieldGetTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *FdrschemaQueriesFieldGetTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
