// Code generated by go-swagger; DO NOT EDIT.

package field_schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new field schema API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for field schema API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	FdrschemaEntitiesFieldGet(params *FdrschemaEntitiesFieldGetParams, opts ...ClientOption) (*FdrschemaEntitiesFieldGetOK, error)

	FdrschemaQueriesFieldGet(params *FdrschemaQueriesFieldGetParams, opts ...ClientOption) (*FdrschemaQueriesFieldGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
FdrschemaEntitiesFieldGet fetches field schema by ID
*/
func (a *Client) FdrschemaEntitiesFieldGet(params *FdrschemaEntitiesFieldGetParams, opts ...ClientOption) (*FdrschemaEntitiesFieldGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFdrschemaEntitiesFieldGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fdrschema.entities.field.get",
		Method:             "GET",
		PathPattern:        "/fdr/entities/schema-fields/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FdrschemaEntitiesFieldGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FdrschemaEntitiesFieldGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for fdrschema.entities.field.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
FdrschemaQueriesFieldGet gets list of field i ds given a particular query
*/
func (a *Client) FdrschemaQueriesFieldGet(params *FdrschemaQueriesFieldGetParams, opts ...ClientOption) (*FdrschemaQueriesFieldGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFdrschemaQueriesFieldGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fdrschema.queries.field.get",
		Method:             "GET",
		PathPattern:        "/fdr/queries/schema-fields/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FdrschemaQueriesFieldGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FdrschemaQueriesFieldGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for fdrschema.queries.field.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
