// Code generated by go-swagger; DO NOT EDIT.

package filevantage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new filevantage API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for filevantage API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetChanges(params *GetChangesParams, opts ...ClientOption) (*GetChangesOK, error)

	QueryChanges(params *QueryChangesParams, opts ...ClientOption) (*QueryChangesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetChanges retrieves information on changes

Retrieve key attributes of Falcon FileVantage changes for the specified ids.
*/
func (a *Client) GetChanges(params *GetChangesParams, opts ...ClientOption) (*GetChangesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetChangesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getChanges",
		Method:             "GET",
		PathPattern:        "/filevantage/entities/changes/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetChangesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetChangesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getChanges: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryChanges returns one or more change i ds

Returns a list of Falcon FileVantage change IDs filtered, sorted and limited by the query parameters provided
*/
func (a *Client) QueryChanges(params *QueryChangesParams, opts ...ClientOption) (*QueryChangesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryChangesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryChanges",
		Method:             "GET",
		PathPattern:        "/filevantage/queries/changes/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryChangesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryChangesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryChanges: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
