// Code generated by go-swagger; DO NOT EDIT.

package filevantage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetChangesParams creates a new GetChangesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetChangesParams() *GetChangesParams {
	return &GetChangesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetChangesParamsWithTimeout creates a new GetChangesParams object
// with the ability to set a timeout on a request.
func NewGetChangesParamsWithTimeout(timeout time.Duration) *GetChangesParams {
	return &GetChangesParams{
		timeout: timeout,
	}
}

// NewGetChangesParamsWithContext creates a new GetChangesParams object
// with the ability to set a context for a request.
func NewGetChangesParamsWithContext(ctx context.Context) *GetChangesParams {
	return &GetChangesParams{
		Context: ctx,
	}
}

// NewGetChangesParamsWithHTTPClient creates a new GetChangesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetChangesParamsWithHTTPClient(client *http.Client) *GetChangesParams {
	return &GetChangesParams{
		HTTPClient: client,
	}
}

/*
GetChangesParams contains all the parameters to send to the API endpoint

	for the get changes operation.

	Typically these are written to a http.Request.
*/
type GetChangesParams struct {

	/* Ids.

	   One or more change ids in the form of ids=ID1&ids=ID2
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get changes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetChangesParams) WithDefaults() *GetChangesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get changes params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetChangesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get changes params
func (o *GetChangesParams) WithTimeout(timeout time.Duration) *GetChangesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get changes params
func (o *GetChangesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get changes params
func (o *GetChangesParams) WithContext(ctx context.Context) *GetChangesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get changes params
func (o *GetChangesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get changes params
func (o *GetChangesParams) WithHTTPClient(client *http.Client) *GetChangesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get changes params
func (o *GetChangesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get changes params
func (o *GetChangesParams) WithIds(ids []string) *GetChangesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get changes params
func (o *GetChangesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetChangesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetChanges binds the parameter ids
func (o *GetChangesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
