// Code generated by go-swagger; DO NOT EDIT.

package filevantage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetChangesReader is a Reader for the GetChanges structure.
type GetChangesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetChangesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetChangesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetChangesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetChangesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetChangesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetChangesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /filevantage/entities/changes/v2] getChanges", response, response.Code())
	}
}

// NewGetChangesOK creates a GetChangesOK with default headers values
func NewGetChangesOK() *GetChangesOK {
	return &GetChangesOK{}
}

/*
GetChangesOK describes a response with status code 200, with default header values.

OK
*/
type GetChangesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.PublicGetChangesResponse
}

// IsSuccess returns true when this get changes o k response has a 2xx status code
func (o *GetChangesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get changes o k response has a 3xx status code
func (o *GetChangesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get changes o k response has a 4xx status code
func (o *GetChangesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get changes o k response has a 5xx status code
func (o *GetChangesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get changes o k response a status code equal to that given
func (o *GetChangesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get changes o k response
func (o *GetChangesOK) Code() int {
	return 200
}

func (o *GetChangesOK) Error() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesOK  %+v", 200, o.Payload)
}

func (o *GetChangesOK) String() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesOK  %+v", 200, o.Payload)
}

func (o *GetChangesOK) GetPayload() *models.PublicGetChangesResponse {
	return o.Payload
}

func (o *GetChangesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.PublicGetChangesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChangesBadRequest creates a GetChangesBadRequest with default headers values
func NewGetChangesBadRequest() *GetChangesBadRequest {
	return &GetChangesBadRequest{}
}

/*
GetChangesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetChangesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get changes bad request response has a 2xx status code
func (o *GetChangesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get changes bad request response has a 3xx status code
func (o *GetChangesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get changes bad request response has a 4xx status code
func (o *GetChangesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get changes bad request response has a 5xx status code
func (o *GetChangesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get changes bad request response a status code equal to that given
func (o *GetChangesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get changes bad request response
func (o *GetChangesBadRequest) Code() int {
	return 400
}

func (o *GetChangesBadRequest) Error() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesBadRequest  %+v", 400, o.Payload)
}

func (o *GetChangesBadRequest) String() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesBadRequest  %+v", 400, o.Payload)
}

func (o *GetChangesBadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetChangesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChangesForbidden creates a GetChangesForbidden with default headers values
func NewGetChangesForbidden() *GetChangesForbidden {
	return &GetChangesForbidden{}
}

/*
GetChangesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetChangesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get changes forbidden response has a 2xx status code
func (o *GetChangesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get changes forbidden response has a 3xx status code
func (o *GetChangesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get changes forbidden response has a 4xx status code
func (o *GetChangesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get changes forbidden response has a 5xx status code
func (o *GetChangesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get changes forbidden response a status code equal to that given
func (o *GetChangesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get changes forbidden response
func (o *GetChangesForbidden) Code() int {
	return 403
}

func (o *GetChangesForbidden) Error() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesForbidden  %+v", 403, o.Payload)
}

func (o *GetChangesForbidden) String() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesForbidden  %+v", 403, o.Payload)
}

func (o *GetChangesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetChangesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChangesTooManyRequests creates a GetChangesTooManyRequests with default headers values
func NewGetChangesTooManyRequests() *GetChangesTooManyRequests {
	return &GetChangesTooManyRequests{}
}

/*
GetChangesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetChangesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get changes too many requests response has a 2xx status code
func (o *GetChangesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get changes too many requests response has a 3xx status code
func (o *GetChangesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get changes too many requests response has a 4xx status code
func (o *GetChangesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get changes too many requests response has a 5xx status code
func (o *GetChangesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get changes too many requests response a status code equal to that given
func (o *GetChangesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get changes too many requests response
func (o *GetChangesTooManyRequests) Code() int {
	return 429
}

func (o *GetChangesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChangesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetChangesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetChangesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetChangesInternalServerError creates a GetChangesInternalServerError with default headers values
func NewGetChangesInternalServerError() *GetChangesInternalServerError {
	return &GetChangesInternalServerError{}
}

/*
GetChangesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetChangesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this get changes internal server error response has a 2xx status code
func (o *GetChangesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get changes internal server error response has a 3xx status code
func (o *GetChangesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get changes internal server error response has a 4xx status code
func (o *GetChangesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get changes internal server error response has a 5xx status code
func (o *GetChangesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get changes internal server error response a status code equal to that given
func (o *GetChangesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get changes internal server error response
func (o *GetChangesInternalServerError) Code() int {
	return 500
}

func (o *GetChangesInternalServerError) Error() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetChangesInternalServerError) String() string {
	return fmt.Sprintf("[GET /filevantage/entities/changes/v2][%d] getChangesInternalServerError  %+v", 500, o.Payload)
}

func (o *GetChangesInternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *GetChangesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
