// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// AggregateEventsReader is a Reader for the AggregateEvents structure.
type AggregateEventsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateEventsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateEventsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAggregateEventsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAggregateEventsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewAggregateEventsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /fwmgr/aggregates/events/GET/v1] aggregate-events", response, response.Code())
	}
}

// NewAggregateEventsOK creates a AggregateEventsOK with default headers values
func NewAggregateEventsOK() *AggregateEventsOK {
	return &AggregateEventsOK{}
}

/*
AggregateEventsOK describes a response with status code 200, with default header values.

OK
*/
type AggregateEventsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIAggregatesResponse
}

// IsSuccess returns true when this aggregate events o k response has a 2xx status code
func (o *AggregateEventsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate events o k response has a 3xx status code
func (o *AggregateEventsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate events o k response has a 4xx status code
func (o *AggregateEventsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate events o k response has a 5xx status code
func (o *AggregateEventsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate events o k response a status code equal to that given
func (o *AggregateEventsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate events o k response
func (o *AggregateEventsOK) Code() int {
	return 200
}

func (o *AggregateEventsOK) Error() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsOK  %+v", 200, o.Payload)
}

func (o *AggregateEventsOK) String() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsOK  %+v", 200, o.Payload)
}

func (o *AggregateEventsOK) GetPayload() *models.FwmgrAPIAggregatesResponse {
	return o.Payload
}

func (o *AggregateEventsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateEventsBadRequest creates a AggregateEventsBadRequest with default headers values
func NewAggregateEventsBadRequest() *AggregateEventsBadRequest {
	return &AggregateEventsBadRequest{}
}

/*
AggregateEventsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type AggregateEventsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this aggregate events bad request response has a 2xx status code
func (o *AggregateEventsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate events bad request response has a 3xx status code
func (o *AggregateEventsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate events bad request response has a 4xx status code
func (o *AggregateEventsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate events bad request response has a 5xx status code
func (o *AggregateEventsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate events bad request response a status code equal to that given
func (o *AggregateEventsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the aggregate events bad request response
func (o *AggregateEventsBadRequest) Code() int {
	return 400
}

func (o *AggregateEventsBadRequest) Error() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsBadRequest  %+v", 400, o.Payload)
}

func (o *AggregateEventsBadRequest) String() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsBadRequest  %+v", 400, o.Payload)
}

func (o *AggregateEventsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *AggregateEventsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateEventsForbidden creates a AggregateEventsForbidden with default headers values
func NewAggregateEventsForbidden() *AggregateEventsForbidden {
	return &AggregateEventsForbidden{}
}

/*
AggregateEventsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AggregateEventsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate events forbidden response has a 2xx status code
func (o *AggregateEventsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate events forbidden response has a 3xx status code
func (o *AggregateEventsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate events forbidden response has a 4xx status code
func (o *AggregateEventsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate events forbidden response has a 5xx status code
func (o *AggregateEventsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate events forbidden response a status code equal to that given
func (o *AggregateEventsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aggregate events forbidden response
func (o *AggregateEventsForbidden) Code() int {
	return 403
}

func (o *AggregateEventsForbidden) Error() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsForbidden  %+v", 403, o.Payload)
}

func (o *AggregateEventsForbidden) String() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsForbidden  %+v", 403, o.Payload)
}

func (o *AggregateEventsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateEventsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateEventsTooManyRequests creates a AggregateEventsTooManyRequests with default headers values
func NewAggregateEventsTooManyRequests() *AggregateEventsTooManyRequests {
	return &AggregateEventsTooManyRequests{}
}

/*
AggregateEventsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type AggregateEventsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this aggregate events too many requests response has a 2xx status code
func (o *AggregateEventsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aggregate events too many requests response has a 3xx status code
func (o *AggregateEventsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate events too many requests response has a 4xx status code
func (o *AggregateEventsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this aggregate events too many requests response has a 5xx status code
func (o *AggregateEventsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate events too many requests response a status code equal to that given
func (o *AggregateEventsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the aggregate events too many requests response
func (o *AggregateEventsTooManyRequests) Code() int {
	return 429
}

func (o *AggregateEventsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateEventsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /fwmgr/aggregates/events/GET/v1][%d] aggregateEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *AggregateEventsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *AggregateEventsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
