// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateRuleGroupReader is a Reader for the CreateRuleGroup structure.
type CreateRuleGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRuleGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRuleGroupCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateRuleGroupBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRuleGroupForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateRuleGroupTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /fwmgr/entities/rule-groups/v1] create-rule-group", response, response.Code())
	}
}

// NewCreateRuleGroupCreated creates a CreateRuleGroupCreated with default headers values
func NewCreateRuleGroupCreated() *CreateRuleGroupCreated {
	return &CreateRuleGroupCreated{}
}

/*
CreateRuleGroupCreated describes a response with status code 201, with default header values.

Created
*/
type CreateRuleGroupCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIQueryResponse
}

// IsSuccess returns true when this create rule group created response has a 2xx status code
func (o *CreateRuleGroupCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create rule group created response has a 3xx status code
func (o *CreateRuleGroupCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group created response has a 4xx status code
func (o *CreateRuleGroupCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create rule group created response has a 5xx status code
func (o *CreateRuleGroupCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group created response a status code equal to that given
func (o *CreateRuleGroupCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create rule group created response
func (o *CreateRuleGroupCreated) Code() int {
	return 201
}

func (o *CreateRuleGroupCreated) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleGroupCreated) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleGroupCreated) GetPayload() *models.FwmgrAPIQueryResponse {
	return o.Payload
}

func (o *CreateRuleGroupCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupBadRequest creates a CreateRuleGroupBadRequest with default headers values
func NewCreateRuleGroupBadRequest() *CreateRuleGroupBadRequest {
	return &CreateRuleGroupBadRequest{}
}

/*
CreateRuleGroupBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateRuleGroupBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this create rule group bad request response has a 2xx status code
func (o *CreateRuleGroupBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group bad request response has a 3xx status code
func (o *CreateRuleGroupBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group bad request response has a 4xx status code
func (o *CreateRuleGroupBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group bad request response has a 5xx status code
func (o *CreateRuleGroupBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group bad request response a status code equal to that given
func (o *CreateRuleGroupBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create rule group bad request response
func (o *CreateRuleGroupBadRequest) Code() int {
	return 400
}

func (o *CreateRuleGroupBadRequest) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRuleGroupBadRequest) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRuleGroupBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *CreateRuleGroupBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupForbidden creates a CreateRuleGroupForbidden with default headers values
func NewCreateRuleGroupForbidden() *CreateRuleGroupForbidden {
	return &CreateRuleGroupForbidden{}
}

/*
CreateRuleGroupForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateRuleGroupForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule group forbidden response has a 2xx status code
func (o *CreateRuleGroupForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group forbidden response has a 3xx status code
func (o *CreateRuleGroupForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group forbidden response has a 4xx status code
func (o *CreateRuleGroupForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group forbidden response has a 5xx status code
func (o *CreateRuleGroupForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group forbidden response a status code equal to that given
func (o *CreateRuleGroupForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create rule group forbidden response
func (o *CreateRuleGroupForbidden) Code() int {
	return 403
}

func (o *CreateRuleGroupForbidden) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleGroupForbidden) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleGroupForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleGroupForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupTooManyRequests creates a CreateRuleGroupTooManyRequests with default headers values
func NewCreateRuleGroupTooManyRequests() *CreateRuleGroupTooManyRequests {
	return &CreateRuleGroupTooManyRequests{}
}

/*
CreateRuleGroupTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateRuleGroupTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule group too many requests response has a 2xx status code
func (o *CreateRuleGroupTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group too many requests response has a 3xx status code
func (o *CreateRuleGroupTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group too many requests response has a 4xx status code
func (o *CreateRuleGroupTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group too many requests response has a 5xx status code
func (o *CreateRuleGroupTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group too many requests response a status code equal to that given
func (o *CreateRuleGroupTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create rule group too many requests response
func (o *CreateRuleGroupTooManyRequests) Code() int {
	return 429
}

func (o *CreateRuleGroupTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleGroupTooManyRequests) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/v1][%d] createRuleGroupTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleGroupTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleGroupTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
