// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewCreateRuleGroupValidationParams creates a new CreateRuleGroupValidationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateRuleGroupValidationParams() *CreateRuleGroupValidationParams {
	return &CreateRuleGroupValidationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateRuleGroupValidationParamsWithTimeout creates a new CreateRuleGroupValidationParams object
// with the ability to set a timeout on a request.
func NewCreateRuleGroupValidationParamsWithTimeout(timeout time.Duration) *CreateRuleGroupValidationParams {
	return &CreateRuleGroupValidationParams{
		timeout: timeout,
	}
}

// NewCreateRuleGroupValidationParamsWithContext creates a new CreateRuleGroupValidationParams object
// with the ability to set a context for a request.
func NewCreateRuleGroupValidationParamsWithContext(ctx context.Context) *CreateRuleGroupValidationParams {
	return &CreateRuleGroupValidationParams{
		Context: ctx,
	}
}

// NewCreateRuleGroupValidationParamsWithHTTPClient creates a new CreateRuleGroupValidationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateRuleGroupValidationParamsWithHTTPClient(client *http.Client) *CreateRuleGroupValidationParams {
	return &CreateRuleGroupValidationParams{
		HTTPClient: client,
	}
}

/*
CreateRuleGroupValidationParams contains all the parameters to send to the API endpoint

	for the create rule group validation operation.

	Typically these are written to a http.Request.
*/
type CreateRuleGroupValidationParams struct {

	// Body.
	Body *models.FwmgrAPIRuleGroupCreateRequestV1

	/* CloneID.

	   A rule group ID from which to copy rules. If this is provided then the 'rules' property of the body is ignored.
	*/
	CloneID *string

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	/* Library.

	   If this flag is set to true then the rules will be cloned from the clone_id from the CrowdStrike Firewall Rule Groups Library.
	*/
	Library *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create rule group validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateRuleGroupValidationParams) WithDefaults() *CreateRuleGroupValidationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create rule group validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateRuleGroupValidationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithTimeout(timeout time.Duration) *CreateRuleGroupValidationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithContext(ctx context.Context) *CreateRuleGroupValidationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithHTTPClient(client *http.Client) *CreateRuleGroupValidationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithBody(body *models.FwmgrAPIRuleGroupCreateRequestV1) *CreateRuleGroupValidationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetBody(body *models.FwmgrAPIRuleGroupCreateRequestV1) {
	o.Body = body
}

// WithCloneID adds the cloneID to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithCloneID(cloneID *string) *CreateRuleGroupValidationParams {
	o.SetCloneID(cloneID)
	return o
}

// SetCloneID adds the cloneId to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetCloneID(cloneID *string) {
	o.CloneID = cloneID
}

// WithComment adds the comment to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithComment(comment *string) *CreateRuleGroupValidationParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithLibrary adds the library to the create rule group validation params
func (o *CreateRuleGroupValidationParams) WithLibrary(library *string) *CreateRuleGroupValidationParams {
	o.SetLibrary(library)
	return o
}

// SetLibrary adds the library to the create rule group validation params
func (o *CreateRuleGroupValidationParams) SetLibrary(library *string) {
	o.Library = library
}

// WriteToRequest writes these params to a swagger request
func (o *CreateRuleGroupValidationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.CloneID != nil {

		// query param clone_id
		var qrCloneID string

		if o.CloneID != nil {
			qrCloneID = *o.CloneID
		}
		qCloneID := qrCloneID
		if qCloneID != "" {

			if err := r.SetQueryParam("clone_id", qCloneID); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Library != nil {

		// query param library
		var qrLibrary string

		if o.Library != nil {
			qrLibrary = *o.Library
		}
		qLibrary := qrLibrary
		if qLibrary != "" {

			if err := r.SetQueryParam("library", qLibrary); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
