// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateRuleGroupValidationReader is a Reader for the CreateRuleGroupValidation structure.
type CreateRuleGroupValidationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRuleGroupValidationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRuleGroupValidationCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateRuleGroupValidationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRuleGroupValidationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateRuleGroupValidationTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /fwmgr/entities/rule-groups/validation/v1] create-rule-group-validation", response, response.Code())
	}
}

// NewCreateRuleGroupValidationCreated creates a CreateRuleGroupValidationCreated with default headers values
func NewCreateRuleGroupValidationCreated() *CreateRuleGroupValidationCreated {
	return &CreateRuleGroupValidationCreated{}
}

/*
CreateRuleGroupValidationCreated describes a response with status code 201, with default header values.

Created
*/
type CreateRuleGroupValidationCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecQueryResponse
}

// IsSuccess returns true when this create rule group validation created response has a 2xx status code
func (o *CreateRuleGroupValidationCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create rule group validation created response has a 3xx status code
func (o *CreateRuleGroupValidationCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group validation created response has a 4xx status code
func (o *CreateRuleGroupValidationCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create rule group validation created response has a 5xx status code
func (o *CreateRuleGroupValidationCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group validation created response a status code equal to that given
func (o *CreateRuleGroupValidationCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create rule group validation created response
func (o *CreateRuleGroupValidationCreated) Code() int {
	return 201
}

func (o *CreateRuleGroupValidationCreated) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleGroupValidationCreated) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationCreated  %+v", 201, o.Payload)
}

func (o *CreateRuleGroupValidationCreated) GetPayload() *models.FwmgrMsaspecQueryResponse {
	return o.Payload
}

func (o *CreateRuleGroupValidationCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupValidationBadRequest creates a CreateRuleGroupValidationBadRequest with default headers values
func NewCreateRuleGroupValidationBadRequest() *CreateRuleGroupValidationBadRequest {
	return &CreateRuleGroupValidationBadRequest{}
}

/*
CreateRuleGroupValidationBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateRuleGroupValidationBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this create rule group validation bad request response has a 2xx status code
func (o *CreateRuleGroupValidationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group validation bad request response has a 3xx status code
func (o *CreateRuleGroupValidationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group validation bad request response has a 4xx status code
func (o *CreateRuleGroupValidationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group validation bad request response has a 5xx status code
func (o *CreateRuleGroupValidationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group validation bad request response a status code equal to that given
func (o *CreateRuleGroupValidationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create rule group validation bad request response
func (o *CreateRuleGroupValidationBadRequest) Code() int {
	return 400
}

func (o *CreateRuleGroupValidationBadRequest) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRuleGroupValidationBadRequest) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRuleGroupValidationBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *CreateRuleGroupValidationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupValidationForbidden creates a CreateRuleGroupValidationForbidden with default headers values
func NewCreateRuleGroupValidationForbidden() *CreateRuleGroupValidationForbidden {
	return &CreateRuleGroupValidationForbidden{}
}

/*
CreateRuleGroupValidationForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateRuleGroupValidationForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule group validation forbidden response has a 2xx status code
func (o *CreateRuleGroupValidationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group validation forbidden response has a 3xx status code
func (o *CreateRuleGroupValidationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group validation forbidden response has a 4xx status code
func (o *CreateRuleGroupValidationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group validation forbidden response has a 5xx status code
func (o *CreateRuleGroupValidationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group validation forbidden response a status code equal to that given
func (o *CreateRuleGroupValidationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create rule group validation forbidden response
func (o *CreateRuleGroupValidationForbidden) Code() int {
	return 403
}

func (o *CreateRuleGroupValidationForbidden) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleGroupValidationForbidden) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationForbidden  %+v", 403, o.Payload)
}

func (o *CreateRuleGroupValidationForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleGroupValidationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRuleGroupValidationTooManyRequests creates a CreateRuleGroupValidationTooManyRequests with default headers values
func NewCreateRuleGroupValidationTooManyRequests() *CreateRuleGroupValidationTooManyRequests {
	return &CreateRuleGroupValidationTooManyRequests{}
}

/*
CreateRuleGroupValidationTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateRuleGroupValidationTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create rule group validation too many requests response has a 2xx status code
func (o *CreateRuleGroupValidationTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create rule group validation too many requests response has a 3xx status code
func (o *CreateRuleGroupValidationTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create rule group validation too many requests response has a 4xx status code
func (o *CreateRuleGroupValidationTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create rule group validation too many requests response has a 5xx status code
func (o *CreateRuleGroupValidationTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create rule group validation too many requests response a status code equal to that given
func (o *CreateRuleGroupValidationTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create rule group validation too many requests response
func (o *CreateRuleGroupValidationTooManyRequests) Code() int {
	return 429
}

func (o *CreateRuleGroupValidationTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleGroupValidationTooManyRequests) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/rule-groups/validation/v1][%d] createRuleGroupValidationTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRuleGroupValidationTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRuleGroupValidationTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
