// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteNetworkLocationsParams creates a new DeleteNetworkLocationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteNetworkLocationsParams() *DeleteNetworkLocationsParams {
	return &DeleteNetworkLocationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteNetworkLocationsParamsWithTimeout creates a new DeleteNetworkLocationsParams object
// with the ability to set a timeout on a request.
func NewDeleteNetworkLocationsParamsWithTimeout(timeout time.Duration) *DeleteNetworkLocationsParams {
	return &DeleteNetworkLocationsParams{
		timeout: timeout,
	}
}

// NewDeleteNetworkLocationsParamsWithContext creates a new DeleteNetworkLocationsParams object
// with the ability to set a context for a request.
func NewDeleteNetworkLocationsParamsWithContext(ctx context.Context) *DeleteNetworkLocationsParams {
	return &DeleteNetworkLocationsParams{
		Context: ctx,
	}
}

// NewDeleteNetworkLocationsParamsWithHTTPClient creates a new DeleteNetworkLocationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteNetworkLocationsParamsWithHTTPClient(client *http.Client) *DeleteNetworkLocationsParams {
	return &DeleteNetworkLocationsParams{
		HTTPClient: client,
	}
}

/*
DeleteNetworkLocationsParams contains all the parameters to send to the API endpoint

	for the delete network locations operation.

	Typically these are written to a http.Request.
*/
type DeleteNetworkLocationsParams struct {

	/* Ids.

	   The IDs of the network locations to be deleted
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteNetworkLocationsParams) WithDefaults() *DeleteNetworkLocationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteNetworkLocationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete network locations params
func (o *DeleteNetworkLocationsParams) WithTimeout(timeout time.Duration) *DeleteNetworkLocationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete network locations params
func (o *DeleteNetworkLocationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete network locations params
func (o *DeleteNetworkLocationsParams) WithContext(ctx context.Context) *DeleteNetworkLocationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete network locations params
func (o *DeleteNetworkLocationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete network locations params
func (o *DeleteNetworkLocationsParams) WithHTTPClient(client *http.Client) *DeleteNetworkLocationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete network locations params
func (o *DeleteNetworkLocationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete network locations params
func (o *DeleteNetworkLocationsParams) WithIds(ids []string) *DeleteNetworkLocationsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete network locations params
func (o *DeleteNetworkLocationsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteNetworkLocationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteNetworkLocations binds the parameter ids
func (o *DeleteNetworkLocationsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
