// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteNetworkLocationsReader is a Reader for the DeleteNetworkLocations structure.
type DeleteNetworkLocationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteNetworkLocationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteNetworkLocationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteNetworkLocationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteNetworkLocationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteNetworkLocationsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /fwmgr/entities/network-locations/v1] delete-network-locations", response, response.Code())
	}
}

// NewDeleteNetworkLocationsOK creates a DeleteNetworkLocationsOK with default headers values
func NewDeleteNetworkLocationsOK() *DeleteNetworkLocationsOK {
	return &DeleteNetworkLocationsOK{}
}

/*
DeleteNetworkLocationsOK describes a response with status code 200, with default header values.

OK
*/
type DeleteNetworkLocationsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecQueryResponse
}

// IsSuccess returns true when this delete network locations o k response has a 2xx status code
func (o *DeleteNetworkLocationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete network locations o k response has a 3xx status code
func (o *DeleteNetworkLocationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete network locations o k response has a 4xx status code
func (o *DeleteNetworkLocationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete network locations o k response has a 5xx status code
func (o *DeleteNetworkLocationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete network locations o k response a status code equal to that given
func (o *DeleteNetworkLocationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete network locations o k response
func (o *DeleteNetworkLocationsOK) Code() int {
	return 200
}

func (o *DeleteNetworkLocationsOK) Error() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *DeleteNetworkLocationsOK) String() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *DeleteNetworkLocationsOK) GetPayload() *models.FwmgrMsaspecQueryResponse {
	return o.Payload
}

func (o *DeleteNetworkLocationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNetworkLocationsBadRequest creates a DeleteNetworkLocationsBadRequest with default headers values
func NewDeleteNetworkLocationsBadRequest() *DeleteNetworkLocationsBadRequest {
	return &DeleteNetworkLocationsBadRequest{}
}

/*
DeleteNetworkLocationsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteNetworkLocationsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this delete network locations bad request response has a 2xx status code
func (o *DeleteNetworkLocationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete network locations bad request response has a 3xx status code
func (o *DeleteNetworkLocationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete network locations bad request response has a 4xx status code
func (o *DeleteNetworkLocationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete network locations bad request response has a 5xx status code
func (o *DeleteNetworkLocationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete network locations bad request response a status code equal to that given
func (o *DeleteNetworkLocationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete network locations bad request response
func (o *DeleteNetworkLocationsBadRequest) Code() int {
	return 400
}

func (o *DeleteNetworkLocationsBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteNetworkLocationsBadRequest) String() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteNetworkLocationsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *DeleteNetworkLocationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNetworkLocationsForbidden creates a DeleteNetworkLocationsForbidden with default headers values
func NewDeleteNetworkLocationsForbidden() *DeleteNetworkLocationsForbidden {
	return &DeleteNetworkLocationsForbidden{}
}

/*
DeleteNetworkLocationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteNetworkLocationsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete network locations forbidden response has a 2xx status code
func (o *DeleteNetworkLocationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete network locations forbidden response has a 3xx status code
func (o *DeleteNetworkLocationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete network locations forbidden response has a 4xx status code
func (o *DeleteNetworkLocationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete network locations forbidden response has a 5xx status code
func (o *DeleteNetworkLocationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete network locations forbidden response a status code equal to that given
func (o *DeleteNetworkLocationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete network locations forbidden response
func (o *DeleteNetworkLocationsForbidden) Code() int {
	return 403
}

func (o *DeleteNetworkLocationsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteNetworkLocationsForbidden) String() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *DeleteNetworkLocationsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteNetworkLocationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNetworkLocationsTooManyRequests creates a DeleteNetworkLocationsTooManyRequests with default headers values
func NewDeleteNetworkLocationsTooManyRequests() *DeleteNetworkLocationsTooManyRequests {
	return &DeleteNetworkLocationsTooManyRequests{}
}

/*
DeleteNetworkLocationsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteNetworkLocationsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete network locations too many requests response has a 2xx status code
func (o *DeleteNetworkLocationsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete network locations too many requests response has a 3xx status code
func (o *DeleteNetworkLocationsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete network locations too many requests response has a 4xx status code
func (o *DeleteNetworkLocationsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete network locations too many requests response has a 5xx status code
func (o *DeleteNetworkLocationsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete network locations too many requests response a status code equal to that given
func (o *DeleteNetworkLocationsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete network locations too many requests response
func (o *DeleteNetworkLocationsTooManyRequests) Code() int {
	return 429
}

func (o *DeleteNetworkLocationsTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteNetworkLocationsTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /fwmgr/entities/network-locations/v1][%d] deleteNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteNetworkLocationsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteNetworkLocationsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
