// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteRuleGroupsParams creates a new DeleteRuleGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteRuleGroupsParams() *DeleteRuleGroupsParams {
	return &DeleteRuleGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteRuleGroupsParamsWithTimeout creates a new DeleteRuleGroupsParams object
// with the ability to set a timeout on a request.
func NewDeleteRuleGroupsParamsWithTimeout(timeout time.Duration) *DeleteRuleGroupsParams {
	return &DeleteRuleGroupsParams{
		timeout: timeout,
	}
}

// NewDeleteRuleGroupsParamsWithContext creates a new DeleteRuleGroupsParams object
// with the ability to set a context for a request.
func NewDeleteRuleGroupsParamsWithContext(ctx context.Context) *DeleteRuleGroupsParams {
	return &DeleteRuleGroupsParams{
		Context: ctx,
	}
}

// NewDeleteRuleGroupsParamsWithHTTPClient creates a new DeleteRuleGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteRuleGroupsParamsWithHTTPClient(client *http.Client) *DeleteRuleGroupsParams {
	return &DeleteRuleGroupsParams{
		HTTPClient: client,
	}
}

/*
DeleteRuleGroupsParams contains all the parameters to send to the API endpoint

	for the delete rule groups operation.

	Typically these are written to a http.Request.
*/
type DeleteRuleGroupsParams struct {

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	/* Ids.

	   The IDs of the rule groups to be deleted
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRuleGroupsParams) WithDefaults() *DeleteRuleGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRuleGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete rule groups params
func (o *DeleteRuleGroupsParams) WithTimeout(timeout time.Duration) *DeleteRuleGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete rule groups params
func (o *DeleteRuleGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete rule groups params
func (o *DeleteRuleGroupsParams) WithContext(ctx context.Context) *DeleteRuleGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete rule groups params
func (o *DeleteRuleGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete rule groups params
func (o *DeleteRuleGroupsParams) WithHTTPClient(client *http.Client) *DeleteRuleGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete rule groups params
func (o *DeleteRuleGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the delete rule groups params
func (o *DeleteRuleGroupsParams) WithComment(comment *string) *DeleteRuleGroupsParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the delete rule groups params
func (o *DeleteRuleGroupsParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithIds adds the ids to the delete rule groups params
func (o *DeleteRuleGroupsParams) WithIds(ids []string) *DeleteRuleGroupsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete rule groups params
func (o *DeleteRuleGroupsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteRuleGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteRuleGroups binds the parameter ids
func (o *DeleteRuleGroupsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
