// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new firewall management API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for firewall management API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregateEvents(params *AggregateEventsParams, opts ...ClientOption) (*AggregateEventsOK, error)

	AggregatePolicyRules(params *AggregatePolicyRulesParams, opts ...ClientOption) (*AggregatePolicyRulesOK, error)

	AggregateRuleGroups(params *AggregateRuleGroupsParams, opts ...ClientOption) (*AggregateRuleGroupsOK, error)

	AggregateRules(params *AggregateRulesParams, opts ...ClientOption) (*AggregateRulesOK, error)

	CreateNetworkLocations(params *CreateNetworkLocationsParams, opts ...ClientOption) (*CreateNetworkLocationsCreated, error)

	CreateRuleGroup(params *CreateRuleGroupParams, opts ...ClientOption) (*CreateRuleGroupCreated, error)

	CreateRuleGroupValidation(params *CreateRuleGroupValidationParams, opts ...ClientOption) (*CreateRuleGroupValidationCreated, error)

	DeleteNetworkLocations(params *DeleteNetworkLocationsParams, opts ...ClientOption) (*DeleteNetworkLocationsOK, error)

	DeleteRuleGroups(params *DeleteRuleGroupsParams, opts ...ClientOption) (*DeleteRuleGroupsOK, error)

	GetEvents(params *GetEventsParams, opts ...ClientOption) (*GetEventsOK, error)

	GetFirewallFields(params *GetFirewallFieldsParams, opts ...ClientOption) (*GetFirewallFieldsOK, error)

	GetNetworkLocations(params *GetNetworkLocationsParams, opts ...ClientOption) (*GetNetworkLocationsOK, error)

	GetNetworkLocationsDetails(params *GetNetworkLocationsDetailsParams, opts ...ClientOption) (*GetNetworkLocationsDetailsOK, error)

	GetPlatforms(params *GetPlatformsParams, opts ...ClientOption) (*GetPlatformsOK, error)

	GetPolicyContainers(params *GetPolicyContainersParams, opts ...ClientOption) (*GetPolicyContainersOK, error)

	GetRuleGroups(params *GetRuleGroupsParams, opts ...ClientOption) (*GetRuleGroupsOK, error)

	GetRules(params *GetRulesParams, opts ...ClientOption) (*GetRulesOK, error)

	QueryEvents(params *QueryEventsParams, opts ...ClientOption) (*QueryEventsOK, error)

	QueryFirewallFields(params *QueryFirewallFieldsParams, opts ...ClientOption) (*QueryFirewallFieldsOK, error)

	QueryNetworkLocations(params *QueryNetworkLocationsParams, opts ...ClientOption) (*QueryNetworkLocationsOK, error)

	QueryPlatforms(params *QueryPlatformsParams, opts ...ClientOption) (*QueryPlatformsOK, error)

	QueryPolicyRules(params *QueryPolicyRulesParams, opts ...ClientOption) (*QueryPolicyRulesOK, error)

	QueryRuleGroups(params *QueryRuleGroupsParams, opts ...ClientOption) (*QueryRuleGroupsOK, error)

	QueryRules(params *QueryRulesParams, opts ...ClientOption) (*QueryRulesOK, error)

	UpdateNetworkLocations(params *UpdateNetworkLocationsParams, opts ...ClientOption) (*UpdateNetworkLocationsOK, error)

	UpdateNetworkLocationsMetadata(params *UpdateNetworkLocationsMetadataParams, opts ...ClientOption) (*UpdateNetworkLocationsMetadataOK, error)

	UpdateNetworkLocationsPrecedence(params *UpdateNetworkLocationsPrecedenceParams, opts ...ClientOption) (*UpdateNetworkLocationsPrecedenceOK, error)

	UpdatePolicyContainer(params *UpdatePolicyContainerParams, opts ...ClientOption) (*UpdatePolicyContainerOK, *UpdatePolicyContainerCreated, error)

	UpdatePolicyContainerV1(params *UpdatePolicyContainerV1Params, opts ...ClientOption) (*UpdatePolicyContainerV1OK, *UpdatePolicyContainerV1Created, error)

	UpdateRuleGroup(params *UpdateRuleGroupParams, opts ...ClientOption) (*UpdateRuleGroupOK, error)

	UpdateRuleGroupValidation(params *UpdateRuleGroupValidationParams, opts ...ClientOption) (*UpdateRuleGroupValidationOK, error)

	UpsertNetworkLocations(params *UpsertNetworkLocationsParams, opts ...ClientOption) (*UpsertNetworkLocationsOK, error)

	ValidateFilepathPattern(params *ValidateFilepathPatternParams, opts ...ClientOption) (*ValidateFilepathPatternOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AggregateEvents aggregates events for customer
*/
func (a *Client) AggregateEvents(params *AggregateEventsParams, opts ...ClientOption) (*AggregateEventsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateEventsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate-events",
		Method:             "POST",
		PathPattern:        "/fwmgr/aggregates/events/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateEventsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateEventsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for aggregate-events: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregatePolicyRules aggregates rules within a policy for customer
*/
func (a *Client) AggregatePolicyRules(params *AggregatePolicyRulesParams, opts ...ClientOption) (*AggregatePolicyRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregatePolicyRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate-policy-rules",
		Method:             "POST",
		PathPattern:        "/fwmgr/aggregates/policy-rules/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregatePolicyRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregatePolicyRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for aggregate-policy-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateRuleGroups aggregates rule groups for customer
*/
func (a *Client) AggregateRuleGroups(params *AggregateRuleGroupsParams, opts ...ClientOption) (*AggregateRuleGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateRuleGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate-rule-groups",
		Method:             "POST",
		PathPattern:        "/fwmgr/aggregates/rule-groups/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateRuleGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateRuleGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for aggregate-rule-groups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateRules aggregates rules for customer
*/
func (a *Client) AggregateRules(params *AggregateRulesParams, opts ...ClientOption) (*AggregateRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aggregate-rules",
		Method:             "POST",
		PathPattern:        "/fwmgr/aggregates/rules/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for aggregate-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateNetworkLocations creates new network locations provided and return the ID
*/
func (a *Client) CreateNetworkLocations(params *CreateNetworkLocationsParams, opts ...ClientOption) (*CreateNetworkLocationsCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "create-network-locations",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateNetworkLocationsCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for create-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRuleGroup creates new rule group on a platform for a customer with a name and description and return the ID
*/
func (a *Client) CreateRuleGroup(params *CreateRuleGroupParams, opts ...ClientOption) (*CreateRuleGroupCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRuleGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "create-rule-group",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRuleGroupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRuleGroupCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for create-rule-group: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRuleGroupValidation validates the request of creating a new rule group on a platform for a customer with a name and description
*/
func (a *Client) CreateRuleGroupValidation(params *CreateRuleGroupValidationParams, opts ...ClientOption) (*CreateRuleGroupValidationCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRuleGroupValidationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "create-rule-group-validation",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/rule-groups/validation/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRuleGroupValidationReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRuleGroupValidationCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for create-rule-group-validation: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteNetworkLocations deletes network location entities by ID
*/
func (a *Client) DeleteNetworkLocations(params *DeleteNetworkLocationsParams, opts ...ClientOption) (*DeleteNetworkLocationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "delete-network-locations",
		Method:             "DELETE",
		PathPattern:        "/fwmgr/entities/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteNetworkLocationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for delete-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRuleGroups deletes rule group entities by ID
*/
func (a *Client) DeleteRuleGroups(params *DeleteRuleGroupsParams, opts ...ClientOption) (*DeleteRuleGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRuleGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "delete-rule-groups",
		Method:             "DELETE",
		PathPattern:        "/fwmgr/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteRuleGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRuleGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for delete-rule-groups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetEvents gets events entities by ID and optionally version
*/
func (a *Client) GetEvents(params *GetEventsParams, opts ...ClientOption) (*GetEventsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetEventsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-events",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetEventsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetEventsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-events: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFirewallFields gets the firewall field specifications by ID
*/
func (a *Client) GetFirewallFields(params *GetFirewallFieldsParams, opts ...ClientOption) (*GetFirewallFieldsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetFirewallFieldsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-firewall-fields",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/firewall-fields/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetFirewallFieldsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFirewallFieldsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-firewall-fields: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNetworkLocations gets a summary of network locations entities by ID

This endpoint returns a summary of network locations that includes name, description, enabled/disabled status, a count of associated rules etc
*/
func (a *Client) GetNetworkLocations(params *GetNetworkLocationsParams, opts ...ClientOption) (*GetNetworkLocationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-network-locations",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNetworkLocationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNetworkLocationsDetails gets network locations entities by ID

This endpoint returns the complete network locations objects that includes all the network location conditions.
*/
func (a *Client) GetNetworkLocationsDetails(params *GetNetworkLocationsDetailsParams, opts ...ClientOption) (*GetNetworkLocationsDetailsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNetworkLocationsDetailsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-network-locations-details",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/network-locations-details/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNetworkLocationsDetailsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNetworkLocationsDetailsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-network-locations-details: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPlatforms gets platforms by ID e g windows or mac or droid
*/
func (a *Client) GetPlatforms(params *GetPlatformsParams, opts ...ClientOption) (*GetPlatformsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPlatformsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-platforms",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/platforms/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetPlatformsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPlatformsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-platforms: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPolicyContainers gets policy container entities by policy ID
*/
func (a *Client) GetPolicyContainers(params *GetPolicyContainersParams, opts ...ClientOption) (*GetPolicyContainersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPolicyContainersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-policy-containers",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/policies/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetPolicyContainersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPolicyContainersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-policy-containers: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRuleGroups gets rule group entities by ID these groups do not contain their rule entites just the rule i ds in precedence order
*/
func (a *Client) GetRuleGroups(params *GetRuleGroupsParams, opts ...ClientOption) (*GetRuleGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRuleGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rule-groups",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRuleGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRuleGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rule-groups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRules gets rule entities by ID 64 bit unsigned int as decimal string or family ID 32 character hexadecimal string
*/
func (a *Client) GetRules(params *GetRulesParams, opts ...ClientOption) (*GetRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "get-rules",
		Method:             "GET",
		PathPattern:        "/fwmgr/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for get-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryEvents finds all event i ds matching the query with filter
*/
func (a *Client) QueryEvents(params *QueryEventsParams, opts ...ClientOption) (*QueryEventsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryEventsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-events",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/events/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryEventsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryEventsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-events: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryFirewallFields gets the firewall field specification i ds for the provided platform
*/
func (a *Client) QueryFirewallFields(params *QueryFirewallFieldsParams, opts ...ClientOption) (*QueryFirewallFieldsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryFirewallFieldsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-firewall-fields",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/firewall-fields/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryFirewallFieldsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryFirewallFieldsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-firewall-fields: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryNetworkLocations gets a list of network location i ds

This endpoint returns a list of network location IDs based of query parameter.
*/
func (a *Client) QueryNetworkLocations(params *QueryNetworkLocationsParams, opts ...ClientOption) (*QueryNetworkLocationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-network-locations",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryNetworkLocationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPlatforms gets the list of platform names
*/
func (a *Client) QueryPlatforms(params *QueryPlatformsParams, opts ...ClientOption) (*QueryPlatformsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPlatformsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-platforms",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/platforms/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPlatformsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPlatformsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-platforms: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPolicyRules finds all firewall rule i ds matching the query with filter and return them in precedence order
*/
func (a *Client) QueryPolicyRules(params *QueryPolicyRulesParams, opts ...ClientOption) (*QueryPolicyRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryPolicyRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-policy-rules",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/policy-rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryPolicyRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPolicyRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-policy-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRuleGroups finds all rule group i ds matching the query with filter
*/
func (a *Client) QueryRuleGroups(params *QueryRuleGroupsParams, opts ...ClientOption) (*QueryRuleGroupsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRuleGroupsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rule-groups",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRuleGroupsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRuleGroupsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rule-groups: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRules finds all rule i ds matching the query with filter
*/
func (a *Client) QueryRules(params *QueryRulesParams, opts ...ClientOption) (*QueryRulesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRulesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "query-rules",
		Method:             "GET",
		PathPattern:        "/fwmgr/queries/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRulesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRulesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for query-rules: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateNetworkLocations updates the network locations provided and return the ID
*/
func (a *Client) UpdateNetworkLocations(params *UpdateNetworkLocationsParams, opts ...ClientOption) (*UpdateNetworkLocationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-network-locations",
		Method:             "PATCH",
		PathPattern:        "/fwmgr/entities/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateNetworkLocationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateNetworkLocationsMetadata updates the network locations metadata such as polling intervals for the cid
*/
func (a *Client) UpdateNetworkLocationsMetadata(params *UpdateNetworkLocationsMetadataParams, opts ...ClientOption) (*UpdateNetworkLocationsMetadataOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateNetworkLocationsMetadataParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-network-locations-metadata",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/network-locations-metadata/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateNetworkLocationsMetadataReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateNetworkLocationsMetadataOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-network-locations-metadata: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateNetworkLocationsPrecedence updates the network locations precedence according to the list of ids provided
*/
func (a *Client) UpdateNetworkLocationsPrecedence(params *UpdateNetworkLocationsPrecedenceParams, opts ...ClientOption) (*UpdateNetworkLocationsPrecedenceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateNetworkLocationsPrecedenceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-network-locations-precedence",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/network-locations-precedence/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateNetworkLocationsPrecedenceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateNetworkLocationsPrecedenceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-network-locations-precedence: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdatePolicyContainer updates an identified policy container including local logging functionality
*/
func (a *Client) UpdatePolicyContainer(params *UpdatePolicyContainerParams, opts ...ClientOption) (*UpdatePolicyContainerOK, *UpdatePolicyContainerCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdatePolicyContainerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-policy-container",
		Method:             "PUT",
		PathPattern:        "/fwmgr/entities/policies/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdatePolicyContainerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *UpdatePolicyContainerOK:
		return value, nil, nil
	case *UpdatePolicyContainerCreated:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for firewall_management: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdatePolicyContainerV1 updates an identified policy container w a r n i n g this endpoint is deprecated in favor of v2 using this endpoint could disable your local logging setting
*/
func (a *Client) UpdatePolicyContainerV1(params *UpdatePolicyContainerV1Params, opts ...ClientOption) (*UpdatePolicyContainerV1OK, *UpdatePolicyContainerV1Created, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdatePolicyContainerV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-policy-container-v1",
		Method:             "PUT",
		PathPattern:        "/fwmgr/entities/policies/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdatePolicyContainerV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *UpdatePolicyContainerV1OK:
		return value, nil, nil
	case *UpdatePolicyContainerV1Created:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for firewall_management: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRuleGroup updates name description or enabled status of a rule group or create edit delete or reorder rules
*/
func (a *Client) UpdateRuleGroup(params *UpdateRuleGroupParams, opts ...ClientOption) (*UpdateRuleGroupOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRuleGroupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-rule-group",
		Method:             "PATCH",
		PathPattern:        "/fwmgr/entities/rule-groups/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRuleGroupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRuleGroupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-rule-group: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRuleGroupValidation validates the request of updating name description or enabled status of a rule group or create edit delete or reorder rules
*/
func (a *Client) UpdateRuleGroupValidation(params *UpdateRuleGroupValidationParams, opts ...ClientOption) (*UpdateRuleGroupValidationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRuleGroupValidationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "update-rule-group-validation",
		Method:             "PATCH",
		PathPattern:        "/fwmgr/entities/rule-groups/validation/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRuleGroupValidationReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRuleGroupValidationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for update-rule-group-validation: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpsertNetworkLocations updates the network locations provided and return the ID
*/
func (a *Client) UpsertNetworkLocations(params *UpsertNetworkLocationsParams, opts ...ClientOption) (*UpsertNetworkLocationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpsertNetworkLocationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "upsert-network-locations",
		Method:             "PUT",
		PathPattern:        "/fwmgr/entities/network-locations/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpsertNetworkLocationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpsertNetworkLocationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for upsert-network-locations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ValidateFilepathPattern validates that the test pattern matches the executable filepath glob pattern
*/
func (a *Client) ValidateFilepathPattern(params *ValidateFilepathPatternParams, opts ...ClientOption) (*ValidateFilepathPatternOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewValidateFilepathPatternParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "validate-filepath-pattern",
		Method:             "POST",
		PathPattern:        "/fwmgr/entities/rules/validate-filepath/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ValidateFilepathPatternReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ValidateFilepathPatternOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for validate-filepath-pattern: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
