// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetEventsParams creates a new GetEventsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetEventsParams() *GetEventsParams {
	return &GetEventsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetEventsParamsWithTimeout creates a new GetEventsParams object
// with the ability to set a timeout on a request.
func NewGetEventsParamsWithTimeout(timeout time.Duration) *GetEventsParams {
	return &GetEventsParams{
		timeout: timeout,
	}
}

// NewGetEventsParamsWithContext creates a new GetEventsParams object
// with the ability to set a context for a request.
func NewGetEventsParamsWithContext(ctx context.Context) *GetEventsParams {
	return &GetEventsParams{
		Context: ctx,
	}
}

// NewGetEventsParamsWithHTTPClient creates a new GetEventsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetEventsParamsWithHTTPClient(client *http.Client) *GetEventsParams {
	return &GetEventsParams{
		HTTPClient: client,
	}
}

/*
GetEventsParams contains all the parameters to send to the API endpoint

	for the get events operation.

	Typically these are written to a http.Request.
*/
type GetEventsParams struct {

	/* Ids.

	   The events to retrieve, identified by ID
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetEventsParams) WithDefaults() *GetEventsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get events params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetEventsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get events params
func (o *GetEventsParams) WithTimeout(timeout time.Duration) *GetEventsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get events params
func (o *GetEventsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get events params
func (o *GetEventsParams) WithContext(ctx context.Context) *GetEventsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get events params
func (o *GetEventsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get events params
func (o *GetEventsParams) WithHTTPClient(client *http.Client) *GetEventsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get events params
func (o *GetEventsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get events params
func (o *GetEventsParams) WithIds(ids []string) *GetEventsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get events params
func (o *GetEventsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetEventsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetEvents binds the parameter ids
func (o *GetEventsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
