// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetEventsReader is a Reader for the GetEvents structure.
type GetEventsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetEventsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetEventsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetEventsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetEventsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetEventsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/events/v1] get-events", response, response.Code())
	}
}

// NewGetEventsOK creates a GetEventsOK with default headers values
func NewGetEventsOK() *GetEventsOK {
	return &GetEventsOK{}
}

/*
GetEventsOK describes a response with status code 200, with default header values.

OK
*/
type GetEventsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIEventsResponse
}

// IsSuccess returns true when this get events o k response has a 2xx status code
func (o *GetEventsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get events o k response has a 3xx status code
func (o *GetEventsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get events o k response has a 4xx status code
func (o *GetEventsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get events o k response has a 5xx status code
func (o *GetEventsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get events o k response a status code equal to that given
func (o *GetEventsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get events o k response
func (o *GetEventsOK) Code() int {
	return 200
}

func (o *GetEventsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsOK  %+v", 200, o.Payload)
}

func (o *GetEventsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsOK  %+v", 200, o.Payload)
}

func (o *GetEventsOK) GetPayload() *models.FwmgrAPIEventsResponse {
	return o.Payload
}

func (o *GetEventsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIEventsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEventsBadRequest creates a GetEventsBadRequest with default headers values
func NewGetEventsBadRequest() *GetEventsBadRequest {
	return &GetEventsBadRequest{}
}

/*
GetEventsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetEventsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get events bad request response has a 2xx status code
func (o *GetEventsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get events bad request response has a 3xx status code
func (o *GetEventsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get events bad request response has a 4xx status code
func (o *GetEventsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get events bad request response has a 5xx status code
func (o *GetEventsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get events bad request response a status code equal to that given
func (o *GetEventsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get events bad request response
func (o *GetEventsBadRequest) Code() int {
	return 400
}

func (o *GetEventsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsBadRequest  %+v", 400, o.Payload)
}

func (o *GetEventsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsBadRequest  %+v", 400, o.Payload)
}

func (o *GetEventsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetEventsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEventsForbidden creates a GetEventsForbidden with default headers values
func NewGetEventsForbidden() *GetEventsForbidden {
	return &GetEventsForbidden{}
}

/*
GetEventsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetEventsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get events forbidden response has a 2xx status code
func (o *GetEventsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get events forbidden response has a 3xx status code
func (o *GetEventsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get events forbidden response has a 4xx status code
func (o *GetEventsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get events forbidden response has a 5xx status code
func (o *GetEventsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get events forbidden response a status code equal to that given
func (o *GetEventsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get events forbidden response
func (o *GetEventsForbidden) Code() int {
	return 403
}

func (o *GetEventsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsForbidden  %+v", 403, o.Payload)
}

func (o *GetEventsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsForbidden  %+v", 403, o.Payload)
}

func (o *GetEventsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetEventsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetEventsTooManyRequests creates a GetEventsTooManyRequests with default headers values
func NewGetEventsTooManyRequests() *GetEventsTooManyRequests {
	return &GetEventsTooManyRequests{}
}

/*
GetEventsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetEventsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get events too many requests response has a 2xx status code
func (o *GetEventsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get events too many requests response has a 3xx status code
func (o *GetEventsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get events too many requests response has a 4xx status code
func (o *GetEventsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get events too many requests response has a 5xx status code
func (o *GetEventsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get events too many requests response a status code equal to that given
func (o *GetEventsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get events too many requests response
func (o *GetEventsTooManyRequests) Code() int {
	return 429
}

func (o *GetEventsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetEventsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/events/v1][%d] getEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetEventsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetEventsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
