// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetFirewallFieldsReader is a Reader for the GetFirewallFields structure.
type GetFirewallFieldsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetFirewallFieldsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetFirewallFieldsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetFirewallFieldsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetFirewallFieldsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/firewall-fields/v1] get-firewall-fields", response, response.Code())
	}
}

// NewGetFirewallFieldsOK creates a GetFirewallFieldsOK with default headers values
func NewGetFirewallFieldsOK() *GetFirewallFieldsOK {
	return &GetFirewallFieldsOK{}
}

/*
GetFirewallFieldsOK describes a response with status code 200, with default header values.

OK
*/
type GetFirewallFieldsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIFirewallFieldsResponse
}

// IsSuccess returns true when this get firewall fields o k response has a 2xx status code
func (o *GetFirewallFieldsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get firewall fields o k response has a 3xx status code
func (o *GetFirewallFieldsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall fields o k response has a 4xx status code
func (o *GetFirewallFieldsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get firewall fields o k response has a 5xx status code
func (o *GetFirewallFieldsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall fields o k response a status code equal to that given
func (o *GetFirewallFieldsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get firewall fields o k response
func (o *GetFirewallFieldsOK) Code() int {
	return 200
}

func (o *GetFirewallFieldsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsOK  %+v", 200, o.Payload)
}

func (o *GetFirewallFieldsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsOK  %+v", 200, o.Payload)
}

func (o *GetFirewallFieldsOK) GetPayload() *models.FwmgrAPIFirewallFieldsResponse {
	return o.Payload
}

func (o *GetFirewallFieldsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIFirewallFieldsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallFieldsForbidden creates a GetFirewallFieldsForbidden with default headers values
func NewGetFirewallFieldsForbidden() *GetFirewallFieldsForbidden {
	return &GetFirewallFieldsForbidden{}
}

/*
GetFirewallFieldsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetFirewallFieldsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get firewall fields forbidden response has a 2xx status code
func (o *GetFirewallFieldsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall fields forbidden response has a 3xx status code
func (o *GetFirewallFieldsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall fields forbidden response has a 4xx status code
func (o *GetFirewallFieldsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get firewall fields forbidden response has a 5xx status code
func (o *GetFirewallFieldsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall fields forbidden response a status code equal to that given
func (o *GetFirewallFieldsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get firewall fields forbidden response
func (o *GetFirewallFieldsForbidden) Code() int {
	return 403
}

func (o *GetFirewallFieldsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsForbidden  %+v", 403, o.Payload)
}

func (o *GetFirewallFieldsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsForbidden  %+v", 403, o.Payload)
}

func (o *GetFirewallFieldsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetFirewallFieldsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFirewallFieldsTooManyRequests creates a GetFirewallFieldsTooManyRequests with default headers values
func NewGetFirewallFieldsTooManyRequests() *GetFirewallFieldsTooManyRequests {
	return &GetFirewallFieldsTooManyRequests{}
}

/*
GetFirewallFieldsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetFirewallFieldsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get firewall fields too many requests response has a 2xx status code
func (o *GetFirewallFieldsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get firewall fields too many requests response has a 3xx status code
func (o *GetFirewallFieldsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get firewall fields too many requests response has a 4xx status code
func (o *GetFirewallFieldsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get firewall fields too many requests response has a 5xx status code
func (o *GetFirewallFieldsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get firewall fields too many requests response a status code equal to that given
func (o *GetFirewallFieldsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get firewall fields too many requests response
func (o *GetFirewallFieldsTooManyRequests) Code() int {
	return 429
}

func (o *GetFirewallFieldsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetFirewallFieldsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/firewall-fields/v1][%d] getFirewallFieldsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetFirewallFieldsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetFirewallFieldsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
