// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetNetworkLocationsDetailsReader is a Reader for the GetNetworkLocationsDetails structure.
type GetNetworkLocationsDetailsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetNetworkLocationsDetailsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetNetworkLocationsDetailsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetNetworkLocationsDetailsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetNetworkLocationsDetailsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetNetworkLocationsDetailsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/network-locations-details/v1] get-network-locations-details", response, response.Code())
	}
}

// NewGetNetworkLocationsDetailsOK creates a GetNetworkLocationsDetailsOK with default headers values
func NewGetNetworkLocationsDetailsOK() *GetNetworkLocationsDetailsOK {
	return &GetNetworkLocationsDetailsOK{}
}

/*
GetNetworkLocationsDetailsOK describes a response with status code 200, with default header values.

OK
*/
type GetNetworkLocationsDetailsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPINetworkLocationsResponse
}

// IsSuccess returns true when this get network locations details o k response has a 2xx status code
func (o *GetNetworkLocationsDetailsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get network locations details o k response has a 3xx status code
func (o *GetNetworkLocationsDetailsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations details o k response has a 4xx status code
func (o *GetNetworkLocationsDetailsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get network locations details o k response has a 5xx status code
func (o *GetNetworkLocationsDetailsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations details o k response a status code equal to that given
func (o *GetNetworkLocationsDetailsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get network locations details o k response
func (o *GetNetworkLocationsDetailsOK) Code() int {
	return 200
}

func (o *GetNetworkLocationsDetailsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsOK  %+v", 200, o.Payload)
}

func (o *GetNetworkLocationsDetailsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsOK  %+v", 200, o.Payload)
}

func (o *GetNetworkLocationsDetailsOK) GetPayload() *models.FwmgrAPINetworkLocationsResponse {
	return o.Payload
}

func (o *GetNetworkLocationsDetailsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPINetworkLocationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsDetailsBadRequest creates a GetNetworkLocationsDetailsBadRequest with default headers values
func NewGetNetworkLocationsDetailsBadRequest() *GetNetworkLocationsDetailsBadRequest {
	return &GetNetworkLocationsDetailsBadRequest{}
}

/*
GetNetworkLocationsDetailsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetNetworkLocationsDetailsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get network locations details bad request response has a 2xx status code
func (o *GetNetworkLocationsDetailsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations details bad request response has a 3xx status code
func (o *GetNetworkLocationsDetailsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations details bad request response has a 4xx status code
func (o *GetNetworkLocationsDetailsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations details bad request response has a 5xx status code
func (o *GetNetworkLocationsDetailsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations details bad request response a status code equal to that given
func (o *GetNetworkLocationsDetailsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get network locations details bad request response
func (o *GetNetworkLocationsDetailsBadRequest) Code() int {
	return 400
}

func (o *GetNetworkLocationsDetailsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsBadRequest  %+v", 400, o.Payload)
}

func (o *GetNetworkLocationsDetailsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsBadRequest  %+v", 400, o.Payload)
}

func (o *GetNetworkLocationsDetailsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetNetworkLocationsDetailsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsDetailsForbidden creates a GetNetworkLocationsDetailsForbidden with default headers values
func NewGetNetworkLocationsDetailsForbidden() *GetNetworkLocationsDetailsForbidden {
	return &GetNetworkLocationsDetailsForbidden{}
}

/*
GetNetworkLocationsDetailsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetNetworkLocationsDetailsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get network locations details forbidden response has a 2xx status code
func (o *GetNetworkLocationsDetailsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations details forbidden response has a 3xx status code
func (o *GetNetworkLocationsDetailsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations details forbidden response has a 4xx status code
func (o *GetNetworkLocationsDetailsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations details forbidden response has a 5xx status code
func (o *GetNetworkLocationsDetailsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations details forbidden response a status code equal to that given
func (o *GetNetworkLocationsDetailsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get network locations details forbidden response
func (o *GetNetworkLocationsDetailsForbidden) Code() int {
	return 403
}

func (o *GetNetworkLocationsDetailsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsForbidden  %+v", 403, o.Payload)
}

func (o *GetNetworkLocationsDetailsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsForbidden  %+v", 403, o.Payload)
}

func (o *GetNetworkLocationsDetailsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetNetworkLocationsDetailsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsDetailsTooManyRequests creates a GetNetworkLocationsDetailsTooManyRequests with default headers values
func NewGetNetworkLocationsDetailsTooManyRequests() *GetNetworkLocationsDetailsTooManyRequests {
	return &GetNetworkLocationsDetailsTooManyRequests{}
}

/*
GetNetworkLocationsDetailsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetNetworkLocationsDetailsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get network locations details too many requests response has a 2xx status code
func (o *GetNetworkLocationsDetailsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations details too many requests response has a 3xx status code
func (o *GetNetworkLocationsDetailsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations details too many requests response has a 4xx status code
func (o *GetNetworkLocationsDetailsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations details too many requests response has a 5xx status code
func (o *GetNetworkLocationsDetailsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations details too many requests response a status code equal to that given
func (o *GetNetworkLocationsDetailsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get network locations details too many requests response
func (o *GetNetworkLocationsDetailsTooManyRequests) Code() int {
	return 429
}

func (o *GetNetworkLocationsDetailsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNetworkLocationsDetailsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations-details/v1][%d] getNetworkLocationsDetailsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNetworkLocationsDetailsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetNetworkLocationsDetailsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
