// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetNetworkLocationsReader is a Reader for the GetNetworkLocations structure.
type GetNetworkLocationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetNetworkLocationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetNetworkLocationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetNetworkLocationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetNetworkLocationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetNetworkLocationsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/network-locations/v1] get-network-locations", response, response.Code())
	}
}

// NewGetNetworkLocationsOK creates a GetNetworkLocationsOK with default headers values
func NewGetNetworkLocationsOK() *GetNetworkLocationsOK {
	return &GetNetworkLocationsOK{}
}

/*
GetNetworkLocationsOK describes a response with status code 200, with default header values.

OK
*/
type GetNetworkLocationsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPINetworkLocationSummariesResponse
}

// IsSuccess returns true when this get network locations o k response has a 2xx status code
func (o *GetNetworkLocationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get network locations o k response has a 3xx status code
func (o *GetNetworkLocationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations o k response has a 4xx status code
func (o *GetNetworkLocationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get network locations o k response has a 5xx status code
func (o *GetNetworkLocationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations o k response a status code equal to that given
func (o *GetNetworkLocationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get network locations o k response
func (o *GetNetworkLocationsOK) Code() int {
	return 200
}

func (o *GetNetworkLocationsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *GetNetworkLocationsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *GetNetworkLocationsOK) GetPayload() *models.FwmgrAPINetworkLocationSummariesResponse {
	return o.Payload
}

func (o *GetNetworkLocationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPINetworkLocationSummariesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsBadRequest creates a GetNetworkLocationsBadRequest with default headers values
func NewGetNetworkLocationsBadRequest() *GetNetworkLocationsBadRequest {
	return &GetNetworkLocationsBadRequest{}
}

/*
GetNetworkLocationsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetNetworkLocationsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get network locations bad request response has a 2xx status code
func (o *GetNetworkLocationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations bad request response has a 3xx status code
func (o *GetNetworkLocationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations bad request response has a 4xx status code
func (o *GetNetworkLocationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations bad request response has a 5xx status code
func (o *GetNetworkLocationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations bad request response a status code equal to that given
func (o *GetNetworkLocationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get network locations bad request response
func (o *GetNetworkLocationsBadRequest) Code() int {
	return 400
}

func (o *GetNetworkLocationsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *GetNetworkLocationsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *GetNetworkLocationsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetNetworkLocationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsForbidden creates a GetNetworkLocationsForbidden with default headers values
func NewGetNetworkLocationsForbidden() *GetNetworkLocationsForbidden {
	return &GetNetworkLocationsForbidden{}
}

/*
GetNetworkLocationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetNetworkLocationsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get network locations forbidden response has a 2xx status code
func (o *GetNetworkLocationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations forbidden response has a 3xx status code
func (o *GetNetworkLocationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations forbidden response has a 4xx status code
func (o *GetNetworkLocationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations forbidden response has a 5xx status code
func (o *GetNetworkLocationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations forbidden response a status code equal to that given
func (o *GetNetworkLocationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get network locations forbidden response
func (o *GetNetworkLocationsForbidden) Code() int {
	return 403
}

func (o *GetNetworkLocationsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *GetNetworkLocationsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *GetNetworkLocationsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetNetworkLocationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNetworkLocationsTooManyRequests creates a GetNetworkLocationsTooManyRequests with default headers values
func NewGetNetworkLocationsTooManyRequests() *GetNetworkLocationsTooManyRequests {
	return &GetNetworkLocationsTooManyRequests{}
}

/*
GetNetworkLocationsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetNetworkLocationsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get network locations too many requests response has a 2xx status code
func (o *GetNetworkLocationsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get network locations too many requests response has a 3xx status code
func (o *GetNetworkLocationsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get network locations too many requests response has a 4xx status code
func (o *GetNetworkLocationsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get network locations too many requests response has a 5xx status code
func (o *GetNetworkLocationsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get network locations too many requests response a status code equal to that given
func (o *GetNetworkLocationsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get network locations too many requests response
func (o *GetNetworkLocationsTooManyRequests) Code() int {
	return 429
}

func (o *GetNetworkLocationsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNetworkLocationsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/network-locations/v1][%d] getNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNetworkLocationsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetNetworkLocationsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
