// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetPlatformsParams creates a new GetPlatformsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetPlatformsParams() *GetPlatformsParams {
	return &GetPlatformsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetPlatformsParamsWithTimeout creates a new GetPlatformsParams object
// with the ability to set a timeout on a request.
func NewGetPlatformsParamsWithTimeout(timeout time.Duration) *GetPlatformsParams {
	return &GetPlatformsParams{
		timeout: timeout,
	}
}

// NewGetPlatformsParamsWithContext creates a new GetPlatformsParams object
// with the ability to set a context for a request.
func NewGetPlatformsParamsWithContext(ctx context.Context) *GetPlatformsParams {
	return &GetPlatformsParams{
		Context: ctx,
	}
}

// NewGetPlatformsParamsWithHTTPClient creates a new GetPlatformsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetPlatformsParamsWithHTTPClient(client *http.Client) *GetPlatformsParams {
	return &GetPlatformsParams{
		HTTPClient: client,
	}
}

/*
GetPlatformsParams contains all the parameters to send to the API endpoint

	for the get platforms operation.

	Typically these are written to a http.Request.
*/
type GetPlatformsParams struct {

	/* Ids.

	   The IDs of the platforms to retrieve
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get platforms params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetPlatformsParams) WithDefaults() *GetPlatformsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get platforms params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetPlatformsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get platforms params
func (o *GetPlatformsParams) WithTimeout(timeout time.Duration) *GetPlatformsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get platforms params
func (o *GetPlatformsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get platforms params
func (o *GetPlatformsParams) WithContext(ctx context.Context) *GetPlatformsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get platforms params
func (o *GetPlatformsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get platforms params
func (o *GetPlatformsParams) WithHTTPClient(client *http.Client) *GetPlatformsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get platforms params
func (o *GetPlatformsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get platforms params
func (o *GetPlatformsParams) WithIds(ids []string) *GetPlatformsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get platforms params
func (o *GetPlatformsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetPlatformsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetPlatforms binds the parameter ids
func (o *GetPlatformsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
