// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetPolicyContainersReader is a Reader for the GetPolicyContainers structure.
type GetPolicyContainersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPolicyContainersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPolicyContainersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetPolicyContainersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetPolicyContainersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetPolicyContainersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/policies/v1] get-policy-containers", response, response.Code())
	}
}

// NewGetPolicyContainersOK creates a GetPolicyContainersOK with default headers values
func NewGetPolicyContainersOK() *GetPolicyContainersOK {
	return &GetPolicyContainersOK{}
}

/*
GetPolicyContainersOK describes a response with status code 200, with default header values.

OK
*/
type GetPolicyContainersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIPolicyContainersResponse
}

// IsSuccess returns true when this get policy containers o k response has a 2xx status code
func (o *GetPolicyContainersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get policy containers o k response has a 3xx status code
func (o *GetPolicyContainersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get policy containers o k response has a 4xx status code
func (o *GetPolicyContainersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get policy containers o k response has a 5xx status code
func (o *GetPolicyContainersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get policy containers o k response a status code equal to that given
func (o *GetPolicyContainersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get policy containers o k response
func (o *GetPolicyContainersOK) Code() int {
	return 200
}

func (o *GetPolicyContainersOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersOK  %+v", 200, o.Payload)
}

func (o *GetPolicyContainersOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersOK  %+v", 200, o.Payload)
}

func (o *GetPolicyContainersOK) GetPayload() *models.FwmgrAPIPolicyContainersResponse {
	return o.Payload
}

func (o *GetPolicyContainersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIPolicyContainersResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPolicyContainersBadRequest creates a GetPolicyContainersBadRequest with default headers values
func NewGetPolicyContainersBadRequest() *GetPolicyContainersBadRequest {
	return &GetPolicyContainersBadRequest{}
}

/*
GetPolicyContainersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetPolicyContainersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get policy containers bad request response has a 2xx status code
func (o *GetPolicyContainersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get policy containers bad request response has a 3xx status code
func (o *GetPolicyContainersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get policy containers bad request response has a 4xx status code
func (o *GetPolicyContainersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get policy containers bad request response has a 5xx status code
func (o *GetPolicyContainersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get policy containers bad request response a status code equal to that given
func (o *GetPolicyContainersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get policy containers bad request response
func (o *GetPolicyContainersBadRequest) Code() int {
	return 400
}

func (o *GetPolicyContainersBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersBadRequest  %+v", 400, o.Payload)
}

func (o *GetPolicyContainersBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersBadRequest  %+v", 400, o.Payload)
}

func (o *GetPolicyContainersBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetPolicyContainersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPolicyContainersForbidden creates a GetPolicyContainersForbidden with default headers values
func NewGetPolicyContainersForbidden() *GetPolicyContainersForbidden {
	return &GetPolicyContainersForbidden{}
}

/*
GetPolicyContainersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetPolicyContainersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get policy containers forbidden response has a 2xx status code
func (o *GetPolicyContainersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get policy containers forbidden response has a 3xx status code
func (o *GetPolicyContainersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get policy containers forbidden response has a 4xx status code
func (o *GetPolicyContainersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get policy containers forbidden response has a 5xx status code
func (o *GetPolicyContainersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get policy containers forbidden response a status code equal to that given
func (o *GetPolicyContainersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get policy containers forbidden response
func (o *GetPolicyContainersForbidden) Code() int {
	return 403
}

func (o *GetPolicyContainersForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersForbidden  %+v", 403, o.Payload)
}

func (o *GetPolicyContainersForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersForbidden  %+v", 403, o.Payload)
}

func (o *GetPolicyContainersForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetPolicyContainersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPolicyContainersTooManyRequests creates a GetPolicyContainersTooManyRequests with default headers values
func NewGetPolicyContainersTooManyRequests() *GetPolicyContainersTooManyRequests {
	return &GetPolicyContainersTooManyRequests{}
}

/*
GetPolicyContainersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetPolicyContainersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get policy containers too many requests response has a 2xx status code
func (o *GetPolicyContainersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get policy containers too many requests response has a 3xx status code
func (o *GetPolicyContainersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get policy containers too many requests response has a 4xx status code
func (o *GetPolicyContainersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get policy containers too many requests response has a 5xx status code
func (o *GetPolicyContainersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get policy containers too many requests response a status code equal to that given
func (o *GetPolicyContainersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get policy containers too many requests response
func (o *GetPolicyContainersTooManyRequests) Code() int {
	return 429
}

func (o *GetPolicyContainersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetPolicyContainersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/policies/v1][%d] getPolicyContainersTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetPolicyContainersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetPolicyContainersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
