// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRuleGroupsParams creates a new GetRuleGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRuleGroupsParams() *GetRuleGroupsParams {
	return &GetRuleGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRuleGroupsParamsWithTimeout creates a new GetRuleGroupsParams object
// with the ability to set a timeout on a request.
func NewGetRuleGroupsParamsWithTimeout(timeout time.Duration) *GetRuleGroupsParams {
	return &GetRuleGroupsParams{
		timeout: timeout,
	}
}

// NewGetRuleGroupsParamsWithContext creates a new GetRuleGroupsParams object
// with the ability to set a context for a request.
func NewGetRuleGroupsParamsWithContext(ctx context.Context) *GetRuleGroupsParams {
	return &GetRuleGroupsParams{
		Context: ctx,
	}
}

// NewGetRuleGroupsParamsWithHTTPClient creates a new GetRuleGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetRuleGroupsParamsWithHTTPClient(client *http.Client) *GetRuleGroupsParams {
	return &GetRuleGroupsParams{
		HTTPClient: client,
	}
}

/*
GetRuleGroupsParams contains all the parameters to send to the API endpoint

	for the get rule groups operation.

	Typically these are written to a http.Request.
*/
type GetRuleGroupsParams struct {

	/* Ids.

	   The IDs of the rule groups to retrieve
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRuleGroupsParams) WithDefaults() *GetRuleGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRuleGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get rule groups params
func (o *GetRuleGroupsParams) WithTimeout(timeout time.Duration) *GetRuleGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get rule groups params
func (o *GetRuleGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get rule groups params
func (o *GetRuleGroupsParams) WithContext(ctx context.Context) *GetRuleGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get rule groups params
func (o *GetRuleGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get rule groups params
func (o *GetRuleGroupsParams) WithHTTPClient(client *http.Client) *GetRuleGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get rule groups params
func (o *GetRuleGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get rule groups params
func (o *GetRuleGroupsParams) WithIds(ids []string) *GetRuleGroupsParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get rule groups params
func (o *GetRuleGroupsParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetRuleGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetRuleGroups binds the parameter ids
func (o *GetRuleGroupsParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
