// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetRuleGroupsReader is a Reader for the GetRuleGroups structure.
type GetRuleGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRuleGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRuleGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetRuleGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetRuleGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetRuleGroupsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/rule-groups/v1] get-rule-groups", response, response.Code())
	}
}

// NewGetRuleGroupsOK creates a GetRuleGroupsOK with default headers values
func NewGetRuleGroupsOK() *GetRuleGroupsOK {
	return &GetRuleGroupsOK{}
}

/*
GetRuleGroupsOK describes a response with status code 200, with default header values.

OK
*/
type GetRuleGroupsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIRuleGroupsResponse
}

// IsSuccess returns true when this get rule groups o k response has a 2xx status code
func (o *GetRuleGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get rule groups o k response has a 3xx status code
func (o *GetRuleGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rule groups o k response has a 4xx status code
func (o *GetRuleGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get rule groups o k response has a 5xx status code
func (o *GetRuleGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get rule groups o k response a status code equal to that given
func (o *GetRuleGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get rule groups o k response
func (o *GetRuleGroupsOK) Code() int {
	return 200
}

func (o *GetRuleGroupsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsOK  %+v", 200, o.Payload)
}

func (o *GetRuleGroupsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsOK  %+v", 200, o.Payload)
}

func (o *GetRuleGroupsOK) GetPayload() *models.FwmgrAPIRuleGroupsResponse {
	return o.Payload
}

func (o *GetRuleGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIRuleGroupsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRuleGroupsBadRequest creates a GetRuleGroupsBadRequest with default headers values
func NewGetRuleGroupsBadRequest() *GetRuleGroupsBadRequest {
	return &GetRuleGroupsBadRequest{}
}

/*
GetRuleGroupsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetRuleGroupsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get rule groups bad request response has a 2xx status code
func (o *GetRuleGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rule groups bad request response has a 3xx status code
func (o *GetRuleGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rule groups bad request response has a 4xx status code
func (o *GetRuleGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rule groups bad request response has a 5xx status code
func (o *GetRuleGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get rule groups bad request response a status code equal to that given
func (o *GetRuleGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get rule groups bad request response
func (o *GetRuleGroupsBadRequest) Code() int {
	return 400
}

func (o *GetRuleGroupsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetRuleGroupsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetRuleGroupsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetRuleGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRuleGroupsForbidden creates a GetRuleGroupsForbidden with default headers values
func NewGetRuleGroupsForbidden() *GetRuleGroupsForbidden {
	return &GetRuleGroupsForbidden{}
}

/*
GetRuleGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetRuleGroupsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get rule groups forbidden response has a 2xx status code
func (o *GetRuleGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rule groups forbidden response has a 3xx status code
func (o *GetRuleGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rule groups forbidden response has a 4xx status code
func (o *GetRuleGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rule groups forbidden response has a 5xx status code
func (o *GetRuleGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get rule groups forbidden response a status code equal to that given
func (o *GetRuleGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get rule groups forbidden response
func (o *GetRuleGroupsForbidden) Code() int {
	return 403
}

func (o *GetRuleGroupsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetRuleGroupsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetRuleGroupsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetRuleGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRuleGroupsTooManyRequests creates a GetRuleGroupsTooManyRequests with default headers values
func NewGetRuleGroupsTooManyRequests() *GetRuleGroupsTooManyRequests {
	return &GetRuleGroupsTooManyRequests{}
}

/*
GetRuleGroupsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetRuleGroupsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get rule groups too many requests response has a 2xx status code
func (o *GetRuleGroupsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rule groups too many requests response has a 3xx status code
func (o *GetRuleGroupsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rule groups too many requests response has a 4xx status code
func (o *GetRuleGroupsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rule groups too many requests response has a 5xx status code
func (o *GetRuleGroupsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get rule groups too many requests response a status code equal to that given
func (o *GetRuleGroupsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get rule groups too many requests response
func (o *GetRuleGroupsTooManyRequests) Code() int {
	return 429
}

func (o *GetRuleGroupsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetRuleGroupsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rule-groups/v1][%d] getRuleGroupsTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetRuleGroupsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetRuleGroupsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
