// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetRulesReader is a Reader for the GetRules structure.
type GetRulesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRulesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRulesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetRulesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetRulesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetRulesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/entities/rules/v1] get-rules", response, response.Code())
	}
}

// NewGetRulesOK creates a GetRulesOK with default headers values
func NewGetRulesOK() *GetRulesOK {
	return &GetRulesOK{}
}

/*
GetRulesOK describes a response with status code 200, with default header values.

OK
*/
type GetRulesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIRulesResponse
}

// IsSuccess returns true when this get rules o k response has a 2xx status code
func (o *GetRulesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get rules o k response has a 3xx status code
func (o *GetRulesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rules o k response has a 4xx status code
func (o *GetRulesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get rules o k response has a 5xx status code
func (o *GetRulesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get rules o k response a status code equal to that given
func (o *GetRulesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get rules o k response
func (o *GetRulesOK) Code() int {
	return 200
}

func (o *GetRulesOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesOK  %+v", 200, o.Payload)
}

func (o *GetRulesOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesOK  %+v", 200, o.Payload)
}

func (o *GetRulesOK) GetPayload() *models.FwmgrAPIRulesResponse {
	return o.Payload
}

func (o *GetRulesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIRulesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRulesBadRequest creates a GetRulesBadRequest with default headers values
func NewGetRulesBadRequest() *GetRulesBadRequest {
	return &GetRulesBadRequest{}
}

/*
GetRulesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetRulesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this get rules bad request response has a 2xx status code
func (o *GetRulesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rules bad request response has a 3xx status code
func (o *GetRulesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rules bad request response has a 4xx status code
func (o *GetRulesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rules bad request response has a 5xx status code
func (o *GetRulesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get rules bad request response a status code equal to that given
func (o *GetRulesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get rules bad request response
func (o *GetRulesBadRequest) Code() int {
	return 400
}

func (o *GetRulesBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesBadRequest  %+v", 400, o.Payload)
}

func (o *GetRulesBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesBadRequest  %+v", 400, o.Payload)
}

func (o *GetRulesBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *GetRulesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRulesForbidden creates a GetRulesForbidden with default headers values
func NewGetRulesForbidden() *GetRulesForbidden {
	return &GetRulesForbidden{}
}

/*
GetRulesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetRulesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get rules forbidden response has a 2xx status code
func (o *GetRulesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rules forbidden response has a 3xx status code
func (o *GetRulesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rules forbidden response has a 4xx status code
func (o *GetRulesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rules forbidden response has a 5xx status code
func (o *GetRulesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get rules forbidden response a status code equal to that given
func (o *GetRulesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get rules forbidden response
func (o *GetRulesForbidden) Code() int {
	return 403
}

func (o *GetRulesForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesForbidden  %+v", 403, o.Payload)
}

func (o *GetRulesForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesForbidden  %+v", 403, o.Payload)
}

func (o *GetRulesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetRulesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRulesTooManyRequests creates a GetRulesTooManyRequests with default headers values
func NewGetRulesTooManyRequests() *GetRulesTooManyRequests {
	return &GetRulesTooManyRequests{}
}

/*
GetRulesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetRulesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get rules too many requests response has a 2xx status code
func (o *GetRulesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get rules too many requests response has a 3xx status code
func (o *GetRulesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get rules too many requests response has a 4xx status code
func (o *GetRulesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get rules too many requests response has a 5xx status code
func (o *GetRulesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get rules too many requests response a status code equal to that given
func (o *GetRulesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get rules too many requests response
func (o *GetRulesTooManyRequests) Code() int {
	return 429
}

func (o *GetRulesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetRulesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/entities/rules/v1][%d] getRulesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetRulesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetRulesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
