// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryEventsReader is a Reader for the QueryEvents structure.
type QueryEventsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryEventsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryEventsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryEventsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryEventsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryEventsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/queries/events/v1] query-events", response, response.Code())
	}
}

// NewQueryEventsOK creates a QueryEventsOK with default headers values
func NewQueryEventsOK() *QueryEventsOK {
	return &QueryEventsOK{}
}

/*
QueryEventsOK describes a response with status code 200, with default header values.

OK
*/
type QueryEventsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIQueryResponse
}

// IsSuccess returns true when this query events o k response has a 2xx status code
func (o *QueryEventsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query events o k response has a 3xx status code
func (o *QueryEventsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query events o k response has a 4xx status code
func (o *QueryEventsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query events o k response has a 5xx status code
func (o *QueryEventsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query events o k response a status code equal to that given
func (o *QueryEventsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query events o k response
func (o *QueryEventsOK) Code() int {
	return 200
}

func (o *QueryEventsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsOK  %+v", 200, o.Payload)
}

func (o *QueryEventsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsOK  %+v", 200, o.Payload)
}

func (o *QueryEventsOK) GetPayload() *models.FwmgrAPIQueryResponse {
	return o.Payload
}

func (o *QueryEventsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryEventsBadRequest creates a QueryEventsBadRequest with default headers values
func NewQueryEventsBadRequest() *QueryEventsBadRequest {
	return &QueryEventsBadRequest{}
}

/*
QueryEventsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryEventsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this query events bad request response has a 2xx status code
func (o *QueryEventsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query events bad request response has a 3xx status code
func (o *QueryEventsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query events bad request response has a 4xx status code
func (o *QueryEventsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query events bad request response has a 5xx status code
func (o *QueryEventsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query events bad request response a status code equal to that given
func (o *QueryEventsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query events bad request response
func (o *QueryEventsBadRequest) Code() int {
	return 400
}

func (o *QueryEventsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryEventsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryEventsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *QueryEventsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryEventsForbidden creates a QueryEventsForbidden with default headers values
func NewQueryEventsForbidden() *QueryEventsForbidden {
	return &QueryEventsForbidden{}
}

/*
QueryEventsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryEventsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query events forbidden response has a 2xx status code
func (o *QueryEventsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query events forbidden response has a 3xx status code
func (o *QueryEventsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query events forbidden response has a 4xx status code
func (o *QueryEventsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query events forbidden response has a 5xx status code
func (o *QueryEventsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query events forbidden response a status code equal to that given
func (o *QueryEventsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query events forbidden response
func (o *QueryEventsForbidden) Code() int {
	return 403
}

func (o *QueryEventsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsForbidden  %+v", 403, o.Payload)
}

func (o *QueryEventsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsForbidden  %+v", 403, o.Payload)
}

func (o *QueryEventsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryEventsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryEventsTooManyRequests creates a QueryEventsTooManyRequests with default headers values
func NewQueryEventsTooManyRequests() *QueryEventsTooManyRequests {
	return &QueryEventsTooManyRequests{}
}

/*
QueryEventsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryEventsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query events too many requests response has a 2xx status code
func (o *QueryEventsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query events too many requests response has a 3xx status code
func (o *QueryEventsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query events too many requests response has a 4xx status code
func (o *QueryEventsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query events too many requests response has a 5xx status code
func (o *QueryEventsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query events too many requests response a status code equal to that given
func (o *QueryEventsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query events too many requests response
func (o *QueryEventsTooManyRequests) Code() int {
	return 429
}

func (o *QueryEventsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryEventsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/events/v1][%d] queryEventsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryEventsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryEventsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
