// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryNetworkLocationsReader is a Reader for the QueryNetworkLocations structure.
type QueryNetworkLocationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryNetworkLocationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryNetworkLocationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryNetworkLocationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryNetworkLocationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryNetworkLocationsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /fwmgr/queries/network-locations/v1] query-network-locations", response, response.Code())
	}
}

// NewQueryNetworkLocationsOK creates a QueryNetworkLocationsOK with default headers values
func NewQueryNetworkLocationsOK() *QueryNetworkLocationsOK {
	return &QueryNetworkLocationsOK{}
}

/*
QueryNetworkLocationsOK describes a response with status code 200, with default header values.

OK
*/
type QueryNetworkLocationsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrAPIQueryResponse
}

// IsSuccess returns true when this query network locations o k response has a 2xx status code
func (o *QueryNetworkLocationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query network locations o k response has a 3xx status code
func (o *QueryNetworkLocationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query network locations o k response has a 4xx status code
func (o *QueryNetworkLocationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query network locations o k response has a 5xx status code
func (o *QueryNetworkLocationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query network locations o k response a status code equal to that given
func (o *QueryNetworkLocationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query network locations o k response
func (o *QueryNetworkLocationsOK) Code() int {
	return 200
}

func (o *QueryNetworkLocationsOK) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *QueryNetworkLocationsOK) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *QueryNetworkLocationsOK) GetPayload() *models.FwmgrAPIQueryResponse {
	return o.Payload
}

func (o *QueryNetworkLocationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrAPIQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNetworkLocationsBadRequest creates a QueryNetworkLocationsBadRequest with default headers values
func NewQueryNetworkLocationsBadRequest() *QueryNetworkLocationsBadRequest {
	return &QueryNetworkLocationsBadRequest{}
}

/*
QueryNetworkLocationsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryNetworkLocationsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this query network locations bad request response has a 2xx status code
func (o *QueryNetworkLocationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query network locations bad request response has a 3xx status code
func (o *QueryNetworkLocationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query network locations bad request response has a 4xx status code
func (o *QueryNetworkLocationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query network locations bad request response has a 5xx status code
func (o *QueryNetworkLocationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query network locations bad request response a status code equal to that given
func (o *QueryNetworkLocationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query network locations bad request response
func (o *QueryNetworkLocationsBadRequest) Code() int {
	return 400
}

func (o *QueryNetworkLocationsBadRequest) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryNetworkLocationsBadRequest) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryNetworkLocationsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *QueryNetworkLocationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNetworkLocationsForbidden creates a QueryNetworkLocationsForbidden with default headers values
func NewQueryNetworkLocationsForbidden() *QueryNetworkLocationsForbidden {
	return &QueryNetworkLocationsForbidden{}
}

/*
QueryNetworkLocationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryNetworkLocationsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query network locations forbidden response has a 2xx status code
func (o *QueryNetworkLocationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query network locations forbidden response has a 3xx status code
func (o *QueryNetworkLocationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query network locations forbidden response has a 4xx status code
func (o *QueryNetworkLocationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query network locations forbidden response has a 5xx status code
func (o *QueryNetworkLocationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query network locations forbidden response a status code equal to that given
func (o *QueryNetworkLocationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query network locations forbidden response
func (o *QueryNetworkLocationsForbidden) Code() int {
	return 403
}

func (o *QueryNetworkLocationsForbidden) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *QueryNetworkLocationsForbidden) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *QueryNetworkLocationsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryNetworkLocationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNetworkLocationsTooManyRequests creates a QueryNetworkLocationsTooManyRequests with default headers values
func NewQueryNetworkLocationsTooManyRequests() *QueryNetworkLocationsTooManyRequests {
	return &QueryNetworkLocationsTooManyRequests{}
}

/*
QueryNetworkLocationsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryNetworkLocationsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query network locations too many requests response has a 2xx status code
func (o *QueryNetworkLocationsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query network locations too many requests response has a 3xx status code
func (o *QueryNetworkLocationsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query network locations too many requests response has a 4xx status code
func (o *QueryNetworkLocationsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query network locations too many requests response has a 5xx status code
func (o *QueryNetworkLocationsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query network locations too many requests response a status code equal to that given
func (o *QueryNetworkLocationsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query network locations too many requests response
func (o *QueryNetworkLocationsTooManyRequests) Code() int {
	return 429
}

func (o *QueryNetworkLocationsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNetworkLocationsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /fwmgr/queries/network-locations/v1][%d] queryNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNetworkLocationsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryNetworkLocationsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
