// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryPlatformsParams creates a new QueryPlatformsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryPlatformsParams() *QueryPlatformsParams {
	return &QueryPlatformsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryPlatformsParamsWithTimeout creates a new QueryPlatformsParams object
// with the ability to set a timeout on a request.
func NewQueryPlatformsParamsWithTimeout(timeout time.Duration) *QueryPlatformsParams {
	return &QueryPlatformsParams{
		timeout: timeout,
	}
}

// NewQueryPlatformsParamsWithContext creates a new QueryPlatformsParams object
// with the ability to set a context for a request.
func NewQueryPlatformsParamsWithContext(ctx context.Context) *QueryPlatformsParams {
	return &QueryPlatformsParams{
		Context: ctx,
	}
}

// NewQueryPlatformsParamsWithHTTPClient creates a new QueryPlatformsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryPlatformsParamsWithHTTPClient(client *http.Client) *QueryPlatformsParams {
	return &QueryPlatformsParams{
		HTTPClient: client,
	}
}

/*
QueryPlatformsParams contains all the parameters to send to the API endpoint

	for the query platforms operation.

	Typically these are written to a http.Request.
*/
type QueryPlatformsParams struct {

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query platforms params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPlatformsParams) WithDefaults() *QueryPlatformsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query platforms params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryPlatformsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query platforms params
func (o *QueryPlatformsParams) WithTimeout(timeout time.Duration) *QueryPlatformsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query platforms params
func (o *QueryPlatformsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query platforms params
func (o *QueryPlatformsParams) WithContext(ctx context.Context) *QueryPlatformsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query platforms params
func (o *QueryPlatformsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query platforms params
func (o *QueryPlatformsParams) WithHTTPClient(client *http.Client) *QueryPlatformsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query platforms params
func (o *QueryPlatformsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLimit adds the limit to the query platforms params
func (o *QueryPlatformsParams) WithLimit(limit *int64) *QueryPlatformsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query platforms params
func (o *QueryPlatformsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query platforms params
func (o *QueryPlatformsParams) WithOffset(offset *string) *QueryPlatformsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query platforms params
func (o *QueryPlatformsParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *QueryPlatformsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
