// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryRuleGroupsParams creates a new QueryRuleGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryRuleGroupsParams() *QueryRuleGroupsParams {
	return &QueryRuleGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryRuleGroupsParamsWithTimeout creates a new QueryRuleGroupsParams object
// with the ability to set a timeout on a request.
func NewQueryRuleGroupsParamsWithTimeout(timeout time.Duration) *QueryRuleGroupsParams {
	return &QueryRuleGroupsParams{
		timeout: timeout,
	}
}

// NewQueryRuleGroupsParamsWithContext creates a new QueryRuleGroupsParams object
// with the ability to set a context for a request.
func NewQueryRuleGroupsParamsWithContext(ctx context.Context) *QueryRuleGroupsParams {
	return &QueryRuleGroupsParams{
		Context: ctx,
	}
}

// NewQueryRuleGroupsParamsWithHTTPClient creates a new QueryRuleGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryRuleGroupsParamsWithHTTPClient(client *http.Client) *QueryRuleGroupsParams {
	return &QueryRuleGroupsParams{
		HTTPClient: client,
	}
}

/*
QueryRuleGroupsParams contains all the parameters to send to the API endpoint

	for the query rule groups operation.

	Typically these are written to a http.Request.
*/
type QueryRuleGroupsParams struct {

	/* After.

	   A pagination token used with the `limit` parameter to manage pagination of results. On your first request, don't provide an `after` token. On subsequent requests, provide the `after` token from the previous response to continue from that place in the results.
	*/
	After *string

	/* Filter.

	   FQL query specifying the filter parameters. Filter term criteria: enabled, platform, name, description, etc TODO. Filter range criteria: created_on, modified_on; use any common date format, such as '2010-05-15T14:55:21.892315096Z'.
	*/
	Filter *string

	/* Limit.

	   Number of ids to return.
	*/
	Limit *int64

	/* Offset.

	   Starting index of overall result set from which to return ids.
	*/
	Offset *string

	/* Q.

	   Match query criteria, which includes all the filter string fields, plus TODO
	*/
	Q *string

	/* Sort.

	   Possible order by fields:
	*/
	Sort *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRuleGroupsParams) WithDefaults() *QueryRuleGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query rule groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryRuleGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query rule groups params
func (o *QueryRuleGroupsParams) WithTimeout(timeout time.Duration) *QueryRuleGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query rule groups params
func (o *QueryRuleGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query rule groups params
func (o *QueryRuleGroupsParams) WithContext(ctx context.Context) *QueryRuleGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query rule groups params
func (o *QueryRuleGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query rule groups params
func (o *QueryRuleGroupsParams) WithHTTPClient(client *http.Client) *QueryRuleGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query rule groups params
func (o *QueryRuleGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAfter adds the after to the query rule groups params
func (o *QueryRuleGroupsParams) WithAfter(after *string) *QueryRuleGroupsParams {
	o.SetAfter(after)
	return o
}

// SetAfter adds the after to the query rule groups params
func (o *QueryRuleGroupsParams) SetAfter(after *string) {
	o.After = after
}

// WithFilter adds the filter to the query rule groups params
func (o *QueryRuleGroupsParams) WithFilter(filter *string) *QueryRuleGroupsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query rule groups params
func (o *QueryRuleGroupsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query rule groups params
func (o *QueryRuleGroupsParams) WithLimit(limit *int64) *QueryRuleGroupsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query rule groups params
func (o *QueryRuleGroupsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query rule groups params
func (o *QueryRuleGroupsParams) WithOffset(offset *string) *QueryRuleGroupsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query rule groups params
func (o *QueryRuleGroupsParams) SetOffset(offset *string) {
	o.Offset = offset
}

// WithQ adds the q to the query rule groups params
func (o *QueryRuleGroupsParams) WithQ(q *string) *QueryRuleGroupsParams {
	o.SetQ(q)
	return o
}

// SetQ adds the q to the query rule groups params
func (o *QueryRuleGroupsParams) SetQ(q *string) {
	o.Q = q
}

// WithSort adds the sort to the query rule groups params
func (o *QueryRuleGroupsParams) WithSort(sort *string) *QueryRuleGroupsParams {
	o.SetSort(sort)
	return o
}

// SetSort adds the sort to the query rule groups params
func (o *QueryRuleGroupsParams) SetSort(sort *string) {
	o.Sort = sort
}

// WriteToRequest writes these params to a swagger request
func (o *QueryRuleGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.After != nil {

		// query param after
		var qrAfter string

		if o.After != nil {
			qrAfter = *o.After
		}
		qAfter := qrAfter
		if qAfter != "" {

			if err := r.SetQueryParam("after", qAfter); err != nil {
				return err
			}
		}
	}

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if o.Q != nil {

		// query param q
		var qrQ string

		if o.Q != nil {
			qrQ = *o.Q
		}
		qQ := qrQ
		if qQ != "" {

			if err := r.SetQueryParam("q", qQ); err != nil {
				return err
			}
		}
	}

	if o.Sort != nil {

		// query param sort
		var qrSort string

		if o.Sort != nil {
			qrSort = *o.Sort
		}
		qSort := qrSort
		if qSort != "" {

			if err := r.SetQueryParam("sort", qSort); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
