// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateNetworkLocationsMetadataParams creates a new UpdateNetworkLocationsMetadataParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateNetworkLocationsMetadataParams() *UpdateNetworkLocationsMetadataParams {
	return &UpdateNetworkLocationsMetadataParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateNetworkLocationsMetadataParamsWithTimeout creates a new UpdateNetworkLocationsMetadataParams object
// with the ability to set a timeout on a request.
func NewUpdateNetworkLocationsMetadataParamsWithTimeout(timeout time.Duration) *UpdateNetworkLocationsMetadataParams {
	return &UpdateNetworkLocationsMetadataParams{
		timeout: timeout,
	}
}

// NewUpdateNetworkLocationsMetadataParamsWithContext creates a new UpdateNetworkLocationsMetadataParams object
// with the ability to set a context for a request.
func NewUpdateNetworkLocationsMetadataParamsWithContext(ctx context.Context) *UpdateNetworkLocationsMetadataParams {
	return &UpdateNetworkLocationsMetadataParams{
		Context: ctx,
	}
}

// NewUpdateNetworkLocationsMetadataParamsWithHTTPClient creates a new UpdateNetworkLocationsMetadataParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateNetworkLocationsMetadataParamsWithHTTPClient(client *http.Client) *UpdateNetworkLocationsMetadataParams {
	return &UpdateNetworkLocationsMetadataParams{
		HTTPClient: client,
	}
}

/*
UpdateNetworkLocationsMetadataParams contains all the parameters to send to the API endpoint

	for the update network locations metadata operation.

	Typically these are written to a http.Request.
*/
type UpdateNetworkLocationsMetadataParams struct {

	// Body.
	Body *models.FwmgrAPINetworkLocationModifyMetadataRequestV1

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update network locations metadata params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsMetadataParams) WithDefaults() *UpdateNetworkLocationsMetadataParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update network locations metadata params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsMetadataParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) WithTimeout(timeout time.Duration) *UpdateNetworkLocationsMetadataParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) WithContext(ctx context.Context) *UpdateNetworkLocationsMetadataParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) WithHTTPClient(client *http.Client) *UpdateNetworkLocationsMetadataParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) WithBody(body *models.FwmgrAPINetworkLocationModifyMetadataRequestV1) *UpdateNetworkLocationsMetadataParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) SetBody(body *models.FwmgrAPINetworkLocationModifyMetadataRequestV1) {
	o.Body = body
}

// WithComment adds the comment to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) WithComment(comment *string) *UpdateNetworkLocationsMetadataParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the update network locations metadata params
func (o *UpdateNetworkLocationsMetadataParams) SetComment(comment *string) {
	o.Comment = comment
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateNetworkLocationsMetadataParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
