// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateNetworkLocationsParams creates a new UpdateNetworkLocationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateNetworkLocationsParams() *UpdateNetworkLocationsParams {
	return &UpdateNetworkLocationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateNetworkLocationsParamsWithTimeout creates a new UpdateNetworkLocationsParams object
// with the ability to set a timeout on a request.
func NewUpdateNetworkLocationsParamsWithTimeout(timeout time.Duration) *UpdateNetworkLocationsParams {
	return &UpdateNetworkLocationsParams{
		timeout: timeout,
	}
}

// NewUpdateNetworkLocationsParamsWithContext creates a new UpdateNetworkLocationsParams object
// with the ability to set a context for a request.
func NewUpdateNetworkLocationsParamsWithContext(ctx context.Context) *UpdateNetworkLocationsParams {
	return &UpdateNetworkLocationsParams{
		Context: ctx,
	}
}

// NewUpdateNetworkLocationsParamsWithHTTPClient creates a new UpdateNetworkLocationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateNetworkLocationsParamsWithHTTPClient(client *http.Client) *UpdateNetworkLocationsParams {
	return &UpdateNetworkLocationsParams{
		HTTPClient: client,
	}
}

/*
UpdateNetworkLocationsParams contains all the parameters to send to the API endpoint

	for the update network locations operation.

	Typically these are written to a http.Request.
*/
type UpdateNetworkLocationsParams struct {

	// Body.
	Body *models.FwmgrAPINetworkLocationModifyRequestV1

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsParams) WithDefaults() *UpdateNetworkLocationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update network locations params
func (o *UpdateNetworkLocationsParams) WithTimeout(timeout time.Duration) *UpdateNetworkLocationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update network locations params
func (o *UpdateNetworkLocationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update network locations params
func (o *UpdateNetworkLocationsParams) WithContext(ctx context.Context) *UpdateNetworkLocationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update network locations params
func (o *UpdateNetworkLocationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update network locations params
func (o *UpdateNetworkLocationsParams) WithHTTPClient(client *http.Client) *UpdateNetworkLocationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update network locations params
func (o *UpdateNetworkLocationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update network locations params
func (o *UpdateNetworkLocationsParams) WithBody(body *models.FwmgrAPINetworkLocationModifyRequestV1) *UpdateNetworkLocationsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update network locations params
func (o *UpdateNetworkLocationsParams) SetBody(body *models.FwmgrAPINetworkLocationModifyRequestV1) {
	o.Body = body
}

// WithComment adds the comment to the update network locations params
func (o *UpdateNetworkLocationsParams) WithComment(comment *string) *UpdateNetworkLocationsParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the update network locations params
func (o *UpdateNetworkLocationsParams) SetComment(comment *string) {
	o.Comment = comment
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateNetworkLocationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
