// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateNetworkLocationsPrecedenceParams creates a new UpdateNetworkLocationsPrecedenceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateNetworkLocationsPrecedenceParams() *UpdateNetworkLocationsPrecedenceParams {
	return &UpdateNetworkLocationsPrecedenceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateNetworkLocationsPrecedenceParamsWithTimeout creates a new UpdateNetworkLocationsPrecedenceParams object
// with the ability to set a timeout on a request.
func NewUpdateNetworkLocationsPrecedenceParamsWithTimeout(timeout time.Duration) *UpdateNetworkLocationsPrecedenceParams {
	return &UpdateNetworkLocationsPrecedenceParams{
		timeout: timeout,
	}
}

// NewUpdateNetworkLocationsPrecedenceParamsWithContext creates a new UpdateNetworkLocationsPrecedenceParams object
// with the ability to set a context for a request.
func NewUpdateNetworkLocationsPrecedenceParamsWithContext(ctx context.Context) *UpdateNetworkLocationsPrecedenceParams {
	return &UpdateNetworkLocationsPrecedenceParams{
		Context: ctx,
	}
}

// NewUpdateNetworkLocationsPrecedenceParamsWithHTTPClient creates a new UpdateNetworkLocationsPrecedenceParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateNetworkLocationsPrecedenceParamsWithHTTPClient(client *http.Client) *UpdateNetworkLocationsPrecedenceParams {
	return &UpdateNetworkLocationsPrecedenceParams{
		HTTPClient: client,
	}
}

/*
UpdateNetworkLocationsPrecedenceParams contains all the parameters to send to the API endpoint

	for the update network locations precedence operation.

	Typically these are written to a http.Request.
*/
type UpdateNetworkLocationsPrecedenceParams struct {

	// Body.
	Body *models.FwmgrAPINetworkLocationModifyPrecedenceRequestV1

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update network locations precedence params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsPrecedenceParams) WithDefaults() *UpdateNetworkLocationsPrecedenceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update network locations precedence params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateNetworkLocationsPrecedenceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) WithTimeout(timeout time.Duration) *UpdateNetworkLocationsPrecedenceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) WithContext(ctx context.Context) *UpdateNetworkLocationsPrecedenceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) WithHTTPClient(client *http.Client) *UpdateNetworkLocationsPrecedenceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) WithBody(body *models.FwmgrAPINetworkLocationModifyPrecedenceRequestV1) *UpdateNetworkLocationsPrecedenceParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) SetBody(body *models.FwmgrAPINetworkLocationModifyPrecedenceRequestV1) {
	o.Body = body
}

// WithComment adds the comment to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) WithComment(comment *string) *UpdateNetworkLocationsPrecedenceParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the update network locations precedence params
func (o *UpdateNetworkLocationsPrecedenceParams) SetComment(comment *string) {
	o.Comment = comment
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateNetworkLocationsPrecedenceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
