// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateNetworkLocationsPrecedenceReader is a Reader for the UpdateNetworkLocationsPrecedence structure.
type UpdateNetworkLocationsPrecedenceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateNetworkLocationsPrecedenceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateNetworkLocationsPrecedenceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateNetworkLocationsPrecedenceBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateNetworkLocationsPrecedenceForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateNetworkLocationsPrecedenceTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /fwmgr/entities/network-locations-precedence/v1] update-network-locations-precedence", response, response.Code())
	}
}

// NewUpdateNetworkLocationsPrecedenceOK creates a UpdateNetworkLocationsPrecedenceOK with default headers values
func NewUpdateNetworkLocationsPrecedenceOK() *UpdateNetworkLocationsPrecedenceOK {
	return &UpdateNetworkLocationsPrecedenceOK{}
}

/*
UpdateNetworkLocationsPrecedenceOK describes a response with status code 200, with default header values.

OK
*/
type UpdateNetworkLocationsPrecedenceOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecQueryResponse
}

// IsSuccess returns true when this update network locations precedence o k response has a 2xx status code
func (o *UpdateNetworkLocationsPrecedenceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update network locations precedence o k response has a 3xx status code
func (o *UpdateNetworkLocationsPrecedenceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations precedence o k response has a 4xx status code
func (o *UpdateNetworkLocationsPrecedenceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update network locations precedence o k response has a 5xx status code
func (o *UpdateNetworkLocationsPrecedenceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations precedence o k response a status code equal to that given
func (o *UpdateNetworkLocationsPrecedenceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update network locations precedence o k response
func (o *UpdateNetworkLocationsPrecedenceOK) Code() int {
	return 200
}

func (o *UpdateNetworkLocationsPrecedenceOK) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceOK  %+v", 200, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceOK) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceOK  %+v", 200, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceOK) GetPayload() *models.FwmgrMsaspecQueryResponse {
	return o.Payload
}

func (o *UpdateNetworkLocationsPrecedenceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsPrecedenceBadRequest creates a UpdateNetworkLocationsPrecedenceBadRequest with default headers values
func NewUpdateNetworkLocationsPrecedenceBadRequest() *UpdateNetworkLocationsPrecedenceBadRequest {
	return &UpdateNetworkLocationsPrecedenceBadRequest{}
}

/*
UpdateNetworkLocationsPrecedenceBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateNetworkLocationsPrecedenceBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update network locations precedence bad request response has a 2xx status code
func (o *UpdateNetworkLocationsPrecedenceBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations precedence bad request response has a 3xx status code
func (o *UpdateNetworkLocationsPrecedenceBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations precedence bad request response has a 4xx status code
func (o *UpdateNetworkLocationsPrecedenceBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations precedence bad request response has a 5xx status code
func (o *UpdateNetworkLocationsPrecedenceBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations precedence bad request response a status code equal to that given
func (o *UpdateNetworkLocationsPrecedenceBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update network locations precedence bad request response
func (o *UpdateNetworkLocationsPrecedenceBadRequest) Code() int {
	return 400
}

func (o *UpdateNetworkLocationsPrecedenceBadRequest) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceBadRequest) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdateNetworkLocationsPrecedenceBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsPrecedenceForbidden creates a UpdateNetworkLocationsPrecedenceForbidden with default headers values
func NewUpdateNetworkLocationsPrecedenceForbidden() *UpdateNetworkLocationsPrecedenceForbidden {
	return &UpdateNetworkLocationsPrecedenceForbidden{}
}

/*
UpdateNetworkLocationsPrecedenceForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateNetworkLocationsPrecedenceForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update network locations precedence forbidden response has a 2xx status code
func (o *UpdateNetworkLocationsPrecedenceForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations precedence forbidden response has a 3xx status code
func (o *UpdateNetworkLocationsPrecedenceForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations precedence forbidden response has a 4xx status code
func (o *UpdateNetworkLocationsPrecedenceForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations precedence forbidden response has a 5xx status code
func (o *UpdateNetworkLocationsPrecedenceForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations precedence forbidden response a status code equal to that given
func (o *UpdateNetworkLocationsPrecedenceForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update network locations precedence forbidden response
func (o *UpdateNetworkLocationsPrecedenceForbidden) Code() int {
	return 403
}

func (o *UpdateNetworkLocationsPrecedenceForbidden) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceForbidden) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateNetworkLocationsPrecedenceForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsPrecedenceTooManyRequests creates a UpdateNetworkLocationsPrecedenceTooManyRequests with default headers values
func NewUpdateNetworkLocationsPrecedenceTooManyRequests() *UpdateNetworkLocationsPrecedenceTooManyRequests {
	return &UpdateNetworkLocationsPrecedenceTooManyRequests{}
}

/*
UpdateNetworkLocationsPrecedenceTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateNetworkLocationsPrecedenceTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update network locations precedence too many requests response has a 2xx status code
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations precedence too many requests response has a 3xx status code
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations precedence too many requests response has a 4xx status code
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations precedence too many requests response has a 5xx status code
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations precedence too many requests response a status code equal to that given
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update network locations precedence too many requests response
func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) Code() int {
	return 429
}

func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) String() string {
	return fmt.Sprintf("[POST /fwmgr/entities/network-locations-precedence/v1][%d] updateNetworkLocationsPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateNetworkLocationsPrecedenceTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
