// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateNetworkLocationsReader is a Reader for the UpdateNetworkLocations structure.
type UpdateNetworkLocationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateNetworkLocationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateNetworkLocationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateNetworkLocationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateNetworkLocationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateNetworkLocationsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /fwmgr/entities/network-locations/v1] update-network-locations", response, response.Code())
	}
}

// NewUpdateNetworkLocationsOK creates a UpdateNetworkLocationsOK with default headers values
func NewUpdateNetworkLocationsOK() *UpdateNetworkLocationsOK {
	return &UpdateNetworkLocationsOK{}
}

/*
UpdateNetworkLocationsOK describes a response with status code 200, with default header values.

OK
*/
type UpdateNetworkLocationsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecQueryResponse
}

// IsSuccess returns true when this update network locations o k response has a 2xx status code
func (o *UpdateNetworkLocationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update network locations o k response has a 3xx status code
func (o *UpdateNetworkLocationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations o k response has a 4xx status code
func (o *UpdateNetworkLocationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update network locations o k response has a 5xx status code
func (o *UpdateNetworkLocationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations o k response a status code equal to that given
func (o *UpdateNetworkLocationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update network locations o k response
func (o *UpdateNetworkLocationsOK) Code() int {
	return 200
}

func (o *UpdateNetworkLocationsOK) Error() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *UpdateNetworkLocationsOK) String() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsOK  %+v", 200, o.Payload)
}

func (o *UpdateNetworkLocationsOK) GetPayload() *models.FwmgrMsaspecQueryResponse {
	return o.Payload
}

func (o *UpdateNetworkLocationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsBadRequest creates a UpdateNetworkLocationsBadRequest with default headers values
func NewUpdateNetworkLocationsBadRequest() *UpdateNetworkLocationsBadRequest {
	return &UpdateNetworkLocationsBadRequest{}
}

/*
UpdateNetworkLocationsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateNetworkLocationsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update network locations bad request response has a 2xx status code
func (o *UpdateNetworkLocationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations bad request response has a 3xx status code
func (o *UpdateNetworkLocationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations bad request response has a 4xx status code
func (o *UpdateNetworkLocationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations bad request response has a 5xx status code
func (o *UpdateNetworkLocationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations bad request response a status code equal to that given
func (o *UpdateNetworkLocationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update network locations bad request response
func (o *UpdateNetworkLocationsBadRequest) Code() int {
	return 400
}

func (o *UpdateNetworkLocationsBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNetworkLocationsBadRequest) String() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNetworkLocationsBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdateNetworkLocationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsForbidden creates a UpdateNetworkLocationsForbidden with default headers values
func NewUpdateNetworkLocationsForbidden() *UpdateNetworkLocationsForbidden {
	return &UpdateNetworkLocationsForbidden{}
}

/*
UpdateNetworkLocationsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateNetworkLocationsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update network locations forbidden response has a 2xx status code
func (o *UpdateNetworkLocationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations forbidden response has a 3xx status code
func (o *UpdateNetworkLocationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations forbidden response has a 4xx status code
func (o *UpdateNetworkLocationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations forbidden response has a 5xx status code
func (o *UpdateNetworkLocationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations forbidden response a status code equal to that given
func (o *UpdateNetworkLocationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update network locations forbidden response
func (o *UpdateNetworkLocationsForbidden) Code() int {
	return 403
}

func (o *UpdateNetworkLocationsForbidden) Error() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateNetworkLocationsForbidden) String() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsForbidden  %+v", 403, o.Payload)
}

func (o *UpdateNetworkLocationsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateNetworkLocationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNetworkLocationsTooManyRequests creates a UpdateNetworkLocationsTooManyRequests with default headers values
func NewUpdateNetworkLocationsTooManyRequests() *UpdateNetworkLocationsTooManyRequests {
	return &UpdateNetworkLocationsTooManyRequests{}
}

/*
UpdateNetworkLocationsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateNetworkLocationsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update network locations too many requests response has a 2xx status code
func (o *UpdateNetworkLocationsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update network locations too many requests response has a 3xx status code
func (o *UpdateNetworkLocationsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update network locations too many requests response has a 4xx status code
func (o *UpdateNetworkLocationsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update network locations too many requests response has a 5xx status code
func (o *UpdateNetworkLocationsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update network locations too many requests response a status code equal to that given
func (o *UpdateNetworkLocationsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update network locations too many requests response
func (o *UpdateNetworkLocationsTooManyRequests) Code() int {
	return 429
}

func (o *UpdateNetworkLocationsTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNetworkLocationsTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /fwmgr/entities/network-locations/v1][%d] updateNetworkLocationsTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNetworkLocationsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateNetworkLocationsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
