// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdatePolicyContainerReader is a Reader for the UpdatePolicyContainer structure.
type UpdatePolicyContainerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdatePolicyContainerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdatePolicyContainerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 201:
		result := NewUpdatePolicyContainerCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdatePolicyContainerBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdatePolicyContainerForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdatePolicyContainerTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /fwmgr/entities/policies/v2] update-policy-container", response, response.Code())
	}
}

// NewUpdatePolicyContainerOK creates a UpdatePolicyContainerOK with default headers values
func NewUpdatePolicyContainerOK() *UpdatePolicyContainerOK {
	return &UpdatePolicyContainerOK{}
}

/*
UpdatePolicyContainerOK describes a response with status code 200, with default header values.

OK
*/
type UpdatePolicyContainerOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container o k response has a 2xx status code
func (o *UpdatePolicyContainerOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update policy container o k response has a 3xx status code
func (o *UpdatePolicyContainerOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container o k response has a 4xx status code
func (o *UpdatePolicyContainerOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update policy container o k response has a 5xx status code
func (o *UpdatePolicyContainerOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container o k response a status code equal to that given
func (o *UpdatePolicyContainerOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update policy container o k response
func (o *UpdatePolicyContainerOK) Code() int {
	return 200
}

func (o *UpdatePolicyContainerOK) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerOK  %+v", 200, o.Payload)
}

func (o *UpdatePolicyContainerOK) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerOK  %+v", 200, o.Payload)
}

func (o *UpdatePolicyContainerOK) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerCreated creates a UpdatePolicyContainerCreated with default headers values
func NewUpdatePolicyContainerCreated() *UpdatePolicyContainerCreated {
	return &UpdatePolicyContainerCreated{}
}

/*
UpdatePolicyContainerCreated describes a response with status code 201, with default header values.

Created
*/
type UpdatePolicyContainerCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container created response has a 2xx status code
func (o *UpdatePolicyContainerCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update policy container created response has a 3xx status code
func (o *UpdatePolicyContainerCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container created response has a 4xx status code
func (o *UpdatePolicyContainerCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this update policy container created response has a 5xx status code
func (o *UpdatePolicyContainerCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container created response a status code equal to that given
func (o *UpdatePolicyContainerCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the update policy container created response
func (o *UpdatePolicyContainerCreated) Code() int {
	return 201
}

func (o *UpdatePolicyContainerCreated) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerCreated  %+v", 201, o.Payload)
}

func (o *UpdatePolicyContainerCreated) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerCreated  %+v", 201, o.Payload)
}

func (o *UpdatePolicyContainerCreated) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerBadRequest creates a UpdatePolicyContainerBadRequest with default headers values
func NewUpdatePolicyContainerBadRequest() *UpdatePolicyContainerBadRequest {
	return &UpdatePolicyContainerBadRequest{}
}

/*
UpdatePolicyContainerBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdatePolicyContainerBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container bad request response has a 2xx status code
func (o *UpdatePolicyContainerBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container bad request response has a 3xx status code
func (o *UpdatePolicyContainerBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container bad request response has a 4xx status code
func (o *UpdatePolicyContainerBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container bad request response has a 5xx status code
func (o *UpdatePolicyContainerBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container bad request response a status code equal to that given
func (o *UpdatePolicyContainerBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update policy container bad request response
func (o *UpdatePolicyContainerBadRequest) Code() int {
	return 400
}

func (o *UpdatePolicyContainerBadRequest) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerBadRequest  %+v", 400, o.Payload)
}

func (o *UpdatePolicyContainerBadRequest) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerBadRequest  %+v", 400, o.Payload)
}

func (o *UpdatePolicyContainerBadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerForbidden creates a UpdatePolicyContainerForbidden with default headers values
func NewUpdatePolicyContainerForbidden() *UpdatePolicyContainerForbidden {
	return &UpdatePolicyContainerForbidden{}
}

/*
UpdatePolicyContainerForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdatePolicyContainerForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update policy container forbidden response has a 2xx status code
func (o *UpdatePolicyContainerForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container forbidden response has a 3xx status code
func (o *UpdatePolicyContainerForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container forbidden response has a 4xx status code
func (o *UpdatePolicyContainerForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container forbidden response has a 5xx status code
func (o *UpdatePolicyContainerForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container forbidden response a status code equal to that given
func (o *UpdatePolicyContainerForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update policy container forbidden response
func (o *UpdatePolicyContainerForbidden) Code() int {
	return 403
}

func (o *UpdatePolicyContainerForbidden) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerForbidden  %+v", 403, o.Payload)
}

func (o *UpdatePolicyContainerForbidden) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerForbidden  %+v", 403, o.Payload)
}

func (o *UpdatePolicyContainerForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdatePolicyContainerForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerTooManyRequests creates a UpdatePolicyContainerTooManyRequests with default headers values
func NewUpdatePolicyContainerTooManyRequests() *UpdatePolicyContainerTooManyRequests {
	return &UpdatePolicyContainerTooManyRequests{}
}

/*
UpdatePolicyContainerTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdatePolicyContainerTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update policy container too many requests response has a 2xx status code
func (o *UpdatePolicyContainerTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container too many requests response has a 3xx status code
func (o *UpdatePolicyContainerTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container too many requests response has a 4xx status code
func (o *UpdatePolicyContainerTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container too many requests response has a 5xx status code
func (o *UpdatePolicyContainerTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container too many requests response a status code equal to that given
func (o *UpdatePolicyContainerTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update policy container too many requests response
func (o *UpdatePolicyContainerTooManyRequests) Code() int {
	return 429
}

func (o *UpdatePolicyContainerTooManyRequests) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdatePolicyContainerTooManyRequests) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v2][%d] updatePolicyContainerTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdatePolicyContainerTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdatePolicyContainerTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
