// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdatePolicyContainerV1Reader is a Reader for the UpdatePolicyContainerV1 structure.
type UpdatePolicyContainerV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdatePolicyContainerV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdatePolicyContainerV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 201:
		result := NewUpdatePolicyContainerV1Created()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdatePolicyContainerV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdatePolicyContainerV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdatePolicyContainerV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /fwmgr/entities/policies/v1] update-policy-container-v1", response, response.Code())
	}
}

// NewUpdatePolicyContainerV1OK creates a UpdatePolicyContainerV1OK with default headers values
func NewUpdatePolicyContainerV1OK() *UpdatePolicyContainerV1OK {
	return &UpdatePolicyContainerV1OK{}
}

/*
UpdatePolicyContainerV1OK describes a response with status code 200, with default header values.

OK
*/
type UpdatePolicyContainerV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container v1 o k response has a 2xx status code
func (o *UpdatePolicyContainerV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update policy container v1 o k response has a 3xx status code
func (o *UpdatePolicyContainerV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container v1 o k response has a 4xx status code
func (o *UpdatePolicyContainerV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update policy container v1 o k response has a 5xx status code
func (o *UpdatePolicyContainerV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container v1 o k response a status code equal to that given
func (o *UpdatePolicyContainerV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update policy container v1 o k response
func (o *UpdatePolicyContainerV1OK) Code() int {
	return 200
}

func (o *UpdatePolicyContainerV1OK) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1OK  %+v", 200, o.Payload)
}

func (o *UpdatePolicyContainerV1OK) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1OK  %+v", 200, o.Payload)
}

func (o *UpdatePolicyContainerV1OK) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerV1Created creates a UpdatePolicyContainerV1Created with default headers values
func NewUpdatePolicyContainerV1Created() *UpdatePolicyContainerV1Created {
	return &UpdatePolicyContainerV1Created{}
}

/*
UpdatePolicyContainerV1Created describes a response with status code 201, with default header values.

Created
*/
type UpdatePolicyContainerV1Created struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container v1 created response has a 2xx status code
func (o *UpdatePolicyContainerV1Created) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update policy container v1 created response has a 3xx status code
func (o *UpdatePolicyContainerV1Created) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container v1 created response has a 4xx status code
func (o *UpdatePolicyContainerV1Created) IsClientError() bool {
	return false
}

// IsServerError returns true when this update policy container v1 created response has a 5xx status code
func (o *UpdatePolicyContainerV1Created) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container v1 created response a status code equal to that given
func (o *UpdatePolicyContainerV1Created) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the update policy container v1 created response
func (o *UpdatePolicyContainerV1Created) Code() int {
	return 201
}

func (o *UpdatePolicyContainerV1Created) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1Created  %+v", 201, o.Payload)
}

func (o *UpdatePolicyContainerV1Created) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1Created  %+v", 201, o.Payload)
}

func (o *UpdatePolicyContainerV1Created) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerV1Created) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerV1BadRequest creates a UpdatePolicyContainerV1BadRequest with default headers values
func NewUpdatePolicyContainerV1BadRequest() *UpdatePolicyContainerV1BadRequest {
	return &UpdatePolicyContainerV1BadRequest{}
}

/*
UpdatePolicyContainerV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdatePolicyContainerV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.FwmgrMsaspecResponseFields
}

// IsSuccess returns true when this update policy container v1 bad request response has a 2xx status code
func (o *UpdatePolicyContainerV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container v1 bad request response has a 3xx status code
func (o *UpdatePolicyContainerV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container v1 bad request response has a 4xx status code
func (o *UpdatePolicyContainerV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container v1 bad request response has a 5xx status code
func (o *UpdatePolicyContainerV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container v1 bad request response a status code equal to that given
func (o *UpdatePolicyContainerV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update policy container v1 bad request response
func (o *UpdatePolicyContainerV1BadRequest) Code() int {
	return 400
}

func (o *UpdatePolicyContainerV1BadRequest) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdatePolicyContainerV1BadRequest) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdatePolicyContainerV1BadRequest) GetPayload() *models.FwmgrMsaspecResponseFields {
	return o.Payload
}

func (o *UpdatePolicyContainerV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.FwmgrMsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerV1Forbidden creates a UpdatePolicyContainerV1Forbidden with default headers values
func NewUpdatePolicyContainerV1Forbidden() *UpdatePolicyContainerV1Forbidden {
	return &UpdatePolicyContainerV1Forbidden{}
}

/*
UpdatePolicyContainerV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdatePolicyContainerV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update policy container v1 forbidden response has a 2xx status code
func (o *UpdatePolicyContainerV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container v1 forbidden response has a 3xx status code
func (o *UpdatePolicyContainerV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container v1 forbidden response has a 4xx status code
func (o *UpdatePolicyContainerV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container v1 forbidden response has a 5xx status code
func (o *UpdatePolicyContainerV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container v1 forbidden response a status code equal to that given
func (o *UpdatePolicyContainerV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update policy container v1 forbidden response
func (o *UpdatePolicyContainerV1Forbidden) Code() int {
	return 403
}

func (o *UpdatePolicyContainerV1Forbidden) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdatePolicyContainerV1Forbidden) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdatePolicyContainerV1Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdatePolicyContainerV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePolicyContainerV1TooManyRequests creates a UpdatePolicyContainerV1TooManyRequests with default headers values
func NewUpdatePolicyContainerV1TooManyRequests() *UpdatePolicyContainerV1TooManyRequests {
	return &UpdatePolicyContainerV1TooManyRequests{}
}

/*
UpdatePolicyContainerV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdatePolicyContainerV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update policy container v1 too many requests response has a 2xx status code
func (o *UpdatePolicyContainerV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update policy container v1 too many requests response has a 3xx status code
func (o *UpdatePolicyContainerV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update policy container v1 too many requests response has a 4xx status code
func (o *UpdatePolicyContainerV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update policy container v1 too many requests response has a 5xx status code
func (o *UpdatePolicyContainerV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update policy container v1 too many requests response a status code equal to that given
func (o *UpdatePolicyContainerV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update policy container v1 too many requests response
func (o *UpdatePolicyContainerV1TooManyRequests) Code() int {
	return 429
}

func (o *UpdatePolicyContainerV1TooManyRequests) Error() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdatePolicyContainerV1TooManyRequests) String() string {
	return fmt.Sprintf("[PUT /fwmgr/entities/policies/v1][%d] updatePolicyContainerV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdatePolicyContainerV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdatePolicyContainerV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
