// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpdateRuleGroupValidationParams creates a new UpdateRuleGroupValidationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateRuleGroupValidationParams() *UpdateRuleGroupValidationParams {
	return &UpdateRuleGroupValidationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateRuleGroupValidationParamsWithTimeout creates a new UpdateRuleGroupValidationParams object
// with the ability to set a timeout on a request.
func NewUpdateRuleGroupValidationParamsWithTimeout(timeout time.Duration) *UpdateRuleGroupValidationParams {
	return &UpdateRuleGroupValidationParams{
		timeout: timeout,
	}
}

// NewUpdateRuleGroupValidationParamsWithContext creates a new UpdateRuleGroupValidationParams object
// with the ability to set a context for a request.
func NewUpdateRuleGroupValidationParamsWithContext(ctx context.Context) *UpdateRuleGroupValidationParams {
	return &UpdateRuleGroupValidationParams{
		Context: ctx,
	}
}

// NewUpdateRuleGroupValidationParamsWithHTTPClient creates a new UpdateRuleGroupValidationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateRuleGroupValidationParamsWithHTTPClient(client *http.Client) *UpdateRuleGroupValidationParams {
	return &UpdateRuleGroupValidationParams{
		HTTPClient: client,
	}
}

/*
UpdateRuleGroupValidationParams contains all the parameters to send to the API endpoint

	for the update rule group validation operation.

	Typically these are written to a http.Request.
*/
type UpdateRuleGroupValidationParams struct {

	// Body.
	Body *models.FwmgrAPIRuleGroupModifyRequestV1

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update rule group validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRuleGroupValidationParams) WithDefaults() *UpdateRuleGroupValidationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update rule group validation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRuleGroupValidationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) WithTimeout(timeout time.Duration) *UpdateRuleGroupValidationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) WithContext(ctx context.Context) *UpdateRuleGroupValidationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) WithHTTPClient(client *http.Client) *UpdateRuleGroupValidationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) WithBody(body *models.FwmgrAPIRuleGroupModifyRequestV1) *UpdateRuleGroupValidationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) SetBody(body *models.FwmgrAPIRuleGroupModifyRequestV1) {
	o.Body = body
}

// WithComment adds the comment to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) WithComment(comment *string) *UpdateRuleGroupValidationParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the update rule group validation params
func (o *UpdateRuleGroupValidationParams) SetComment(comment *string) {
	o.Comment = comment
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateRuleGroupValidationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
