// Code generated by go-swagger; DO NOT EDIT.

package firewall_management

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewUpsertNetworkLocationsParams creates a new UpsertNetworkLocationsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpsertNetworkLocationsParams() *UpsertNetworkLocationsParams {
	return &UpsertNetworkLocationsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpsertNetworkLocationsParamsWithTimeout creates a new UpsertNetworkLocationsParams object
// with the ability to set a timeout on a request.
func NewUpsertNetworkLocationsParamsWithTimeout(timeout time.Duration) *UpsertNetworkLocationsParams {
	return &UpsertNetworkLocationsParams{
		timeout: timeout,
	}
}

// NewUpsertNetworkLocationsParamsWithContext creates a new UpsertNetworkLocationsParams object
// with the ability to set a context for a request.
func NewUpsertNetworkLocationsParamsWithContext(ctx context.Context) *UpsertNetworkLocationsParams {
	return &UpsertNetworkLocationsParams{
		Context: ctx,
	}
}

// NewUpsertNetworkLocationsParamsWithHTTPClient creates a new UpsertNetworkLocationsParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpsertNetworkLocationsParamsWithHTTPClient(client *http.Client) *UpsertNetworkLocationsParams {
	return &UpsertNetworkLocationsParams{
		HTTPClient: client,
	}
}

/*
UpsertNetworkLocationsParams contains all the parameters to send to the API endpoint

	for the upsert network locations operation.

	Typically these are written to a http.Request.
*/
type UpsertNetworkLocationsParams struct {

	// Body.
	Body *models.FwmgrAPINetworkLocationModifyRequestV1

	/* Comment.

	   Audit log comment for this action
	*/
	Comment *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the upsert network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpsertNetworkLocationsParams) WithDefaults() *UpsertNetworkLocationsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the upsert network locations params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpsertNetworkLocationsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the upsert network locations params
func (o *UpsertNetworkLocationsParams) WithTimeout(timeout time.Duration) *UpsertNetworkLocationsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the upsert network locations params
func (o *UpsertNetworkLocationsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the upsert network locations params
func (o *UpsertNetworkLocationsParams) WithContext(ctx context.Context) *UpsertNetworkLocationsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the upsert network locations params
func (o *UpsertNetworkLocationsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the upsert network locations params
func (o *UpsertNetworkLocationsParams) WithHTTPClient(client *http.Client) *UpsertNetworkLocationsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the upsert network locations params
func (o *UpsertNetworkLocationsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the upsert network locations params
func (o *UpsertNetworkLocationsParams) WithBody(body *models.FwmgrAPINetworkLocationModifyRequestV1) *UpsertNetworkLocationsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the upsert network locations params
func (o *UpsertNetworkLocationsParams) SetBody(body *models.FwmgrAPINetworkLocationModifyRequestV1) {
	o.Body = body
}

// WithComment adds the comment to the upsert network locations params
func (o *UpsertNetworkLocationsParams) WithComment(comment *string) *UpsertNetworkLocationsParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the upsert network locations params
func (o *UpsertNetworkLocationsParams) SetComment(comment *string) {
	o.Comment = comment
}

// WriteToRequest writes these params to a swagger request
func (o *UpsertNetworkLocationsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
